/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.smcrypto;

import cn.aotcloud.smcrypto.I1iIiI1I;
import cn.aotcloud.smcrypto.Iii11I11;
import cn.aotcloud.smcrypto.exception.InvalidContextException;
import cn.aotcloud.smcrypto.exception.InvalidCryptoDataException;
import cn.aotcloud.smcrypto.exception.InvalidIvException;
import cn.aotcloud.smcrypto.exception.InvalidKeyException;
import cn.aotcloud.smcrypto.exception.InvalidSourceDataException;
import cn.aotcloud.smcrypto.util.ByteUtils;
import cn.aotcloud.smcrypto.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sm4CBCUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)Sm4CBCUtils.class.getName());

    public static String encryptFromText(String string, String string2, String string3) throws InvalidSourceDataException, InvalidKeyException {
        return Sm4CBCUtils.encryptFromText(string, string2, string3, true);
    }

    public static String encryptFromText(String string, String string2, String string3, boolean bl) throws InvalidSourceDataException, InvalidKeyException {
        if (StringUtils.isEmpty(string)) {
            throw new InvalidSourceDataException("[SM4_CBC:encryptFromText]invalid plainText");
        }
        if (StringUtils.length(string2) != 32) {
            throw new InvalidKeyException("[SM4_CBC:encryptFromText]invalid keyHex");
        }
        if (StringUtils.length(string3) != 32) {
            throw new InvalidKeyException("[SM4_CBC:encryptFromText]invalid ivHex");
        }
        byte[] byArray = ByteUtils.stringToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = ByteUtils.hexToBytes(string3);
        byte[] byArray4 = Sm4CBCUtils.encryptFromData(byArray, byArray2, byArray3, bl);
        return ByteUtils.bytesToHex(byArray4);
    }

    public static String encryptFromHex(String string, String string2, String string3) throws InvalidSourceDataException, InvalidKeyException {
        return Sm4CBCUtils.encryptFromHex(string, string2, string3, true);
    }

    public static String encryptFromHex(String string, String string2, String string3, boolean bl) throws InvalidSourceDataException, InvalidKeyException {
        if (StringUtils.isEmpty(string)) {
            throw new InvalidSourceDataException("[SM4_CBC:encryptFromHex]invalid plainHex");
        }
        if (StringUtils.length(string2) != 32) {
            throw new InvalidKeyException("[SM4_CBC:encryptFromHex]invalid keyHex");
        }
        if (StringUtils.length(string3) != 32) {
            throw new InvalidKeyException("[SM4_CBC:encryptFromHex]invalid ivHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = ByteUtils.hexToBytes(string3);
        byte[] byArray4 = Sm4CBCUtils.encryptFromData(byArray, byArray2, byArray3, bl);
        return ByteUtils.bytesToHex(byArray4);
    }

    public static void encryptInputStream(InputStream inputStream, OutputStream outputStream, byte[] byArray, byte[] byArray2) throws IOException, InvalidKeyException, InvalidSourceDataException {
        Sm4CBCUtils.encryptInputStream(inputStream, outputStream, byArray, byArray2, true);
    }

    public static void encryptInputStream(InputStream inputStream, OutputStream outputStream, byte[] byArray, byte[] byArray2, boolean bl) throws IOException, InvalidKeyException, InvalidSourceDataException {
        int n;
        byte[] byArray3 = new byte[1024];
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        int n2 = 0;
        while ((n = inputStream.read(byArray3)) != -1) {
            if (n2 > 0 && byArray4 != null) {
                byArray5 = Sm4CBCUtils.encryptFromData(byArray4, byArray, byArray2, false);
                outputStream.write(byArray5);
            }
            byArray4 = new byte[n];
            System.arraycopy(byArray3, 0, byArray4, 0, n);
            ++n2;
        }
        byArray5 = Sm4CBCUtils.encryptFromData(byArray4, byArray, byArray2, bl);
        outputStream.write(byArray5);
        byArray3 = null;
        byArray4 = null;
        byArray5 = null;
    }

    public static byte[] encryptFromData(byte[] byArray, byte[] byArray2, byte[] byArray3) throws InvalidSourceDataException, InvalidKeyException {
        return Sm4CBCUtils.encryptFromData(byArray, byArray2, byArray3, true);
    }

    public static byte[] encryptFromData(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) throws InvalidSourceDataException, InvalidKeyException {
        if (byArray == null || byArray.length == 0) {
            throw new InvalidSourceDataException("[SM4_CBC:encryptFromData]invalid plainBytes");
        }
        if (byArray2 == null || byArray2.length != 16) {
            throw new InvalidKeyException("[SM4_CBC:encryptFromData]invalid keyBytes");
        }
        if (byArray3 == null || byArray3.length != 16) {
            throw new InvalidKeyException("[SM4_CBC:encryptFromData]invalid ivBytes");
        }
        try {
            Iii11I11 iii11I11 = new Iii11I11();
            iii11I11.i111IiI1 = bl;
            I1iIiI1I i1iIiI1I = new I1iIiI1I();
            i1iIiI1I.II11iIiI(iii11I11, byArray2);
            byte[] byArray4 = i1iIiI1I.II11iIiI(iii11I11, byArray3, byArray);
            return byArray4;
        }
        catch (InvalidContextException invalidContextException) {
            logger.warn("SM4 CBC Model Encrypt InvalidContextException!");
            return null;
        }
        catch (InvalidIvException invalidIvException) {
            logger.warn("SM4 CBC Model Encrypt InvalidIvException!");
            return null;
        }
        catch (IOException iOException) {
            logger.warn("SM4 CBC Model Encrypt IOException!");
            return null;
        }
    }

    public static String decryptToText(String string, String string2, String string3) throws InvalidCryptoDataException, InvalidKeyException {
        return Sm4CBCUtils.decryptToText(string, string2, string3, true);
    }

    public static String decryptToText(String string, String string2, String string3, boolean bl) throws InvalidCryptoDataException, InvalidKeyException {
        if (StringUtils.length(string2) == 0 || string.length() % 32 != 0) {
            throw new InvalidCryptoDataException("[SM4_CBC:decryptToText]invalid cipherHex");
        }
        if (StringUtils.length(string2) != 32) {
            throw new InvalidKeyException("[SM4_CBC:decryptToText]invalid keyHex");
        }
        if (StringUtils.length(string3) != 32) {
            throw new InvalidKeyException("[SM4_CBC:decryptToText]invalid ivHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = ByteUtils.hexToBytes(string3);
        byte[] byArray4 = Sm4CBCUtils.decryptToData(byArray, byArray2, byArray3, bl);
        return ByteUtils.bytesToString(byArray4);
    }

    public static String decryptToHex(String string, String string2, String string3) throws InvalidCryptoDataException, InvalidKeyException {
        return Sm4CBCUtils.decryptToHex(string, string2, string3, true);
    }

    public static String decryptToHex(String string, String string2, String string3, boolean bl) throws InvalidCryptoDataException, InvalidKeyException {
        if (StringUtils.length(string2) == 0 || string.length() % 32 != 0) {
            throw new InvalidCryptoDataException("[SM4_CBC:decryptToHex]invalid cipherHex");
        }
        if (StringUtils.length(string2) != 32) {
            throw new InvalidKeyException("[SM4_CBC:decryptToHex]invalid keyHex");
        }
        if (StringUtils.length(string3) != 32) {
            throw new InvalidKeyException("[SM4_CBC:decryptToHex]invalid ivHex");
        }
        byte[] byArray = ByteUtils.hexToBytes(string);
        byte[] byArray2 = ByteUtils.hexToBytes(string2);
        byte[] byArray3 = ByteUtils.hexToBytes(string3);
        byte[] byArray4 = Sm4CBCUtils.decryptToData(byArray, byArray2, byArray3, bl);
        return ByteUtils.bytesToHex(byArray4);
    }

    public static void decryptInputStream(InputStream inputStream, OutputStream outputStream, byte[] byArray, byte[] byArray2) throws IOException, InvalidKeyException, InvalidCryptoDataException {
        Sm4CBCUtils.decryptInputStream(inputStream, outputStream, byArray, byArray2, true);
    }

    public static void decryptInputStream(InputStream inputStream, OutputStream outputStream, byte[] byArray, byte[] byArray2, boolean bl) throws IOException, InvalidKeyException, InvalidCryptoDataException {
        int n;
        byte[] byArray3 = new byte[1024];
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        int n2 = 0;
        while ((n = inputStream.read(byArray3)) != -1) {
            if (n2 > 0 && byArray4 != null) {
                byArray5 = Sm4CBCUtils.decryptToData(byArray4, byArray, byArray2, false);
                outputStream.write(byArray5);
            }
            byArray4 = new byte[n];
            System.arraycopy(byArray3, 0, byArray4, 0, n);
            ++n2;
        }
        byArray5 = Sm4CBCUtils.decryptToData(byArray4, byArray, byArray2, bl);
        outputStream.write(byArray5);
        byArray3 = null;
        byArray4 = null;
        byArray5 = null;
    }

    public static byte[] decryptToData(byte[] byArray, byte[] byArray2, byte[] byArray3) throws InvalidCryptoDataException, InvalidKeyException {
        return Sm4CBCUtils.decryptToData(byArray, byArray2, byArray3, true);
    }

    public static byte[] decryptToData(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) throws InvalidCryptoDataException, InvalidKeyException {
        if (byArray == null || byArray.length == 0 || byArray.length % 16 != 0) {
            throw new InvalidCryptoDataException("[SM4_CBC:decryptToData]invalid plainBytes");
        }
        if (byArray2 == null || byArray2.length != 16) {
            throw new InvalidKeyException("[SM4_CBC:decryptToData]invalid keyBytes");
        }
        if (byArray3 == null || byArray3.length != 16) {
            throw new InvalidKeyException("[SM4_CBC:decryptToData]invalid ivBytes");
        }
        try {
            Iii11I11 iii11I11 = new Iii11I11();
            iii11I11.i111IiI1 = bl;
            I1iIiI1I i1iIiI1I = new I1iIiI1I();
            i1iIiI1I.I111ii1I(iii11I11, byArray2);
            byte[] byArray4 = i1iIiI1I.II11iIiI(iii11I11, byArray3, byArray);
            return byArray4;
        }
        catch (InvalidContextException invalidContextException) {
            logger.warn("SM4 CBC Model Decrypt InvalidContextException!");
            return null;
        }
        catch (InvalidIvException invalidIvException) {
            logger.warn("SM4 CBC Model Decrypt InvalidIvException!");
            return null;
        }
        catch (IOException iOException) {
            logger.warn("SM4 CBC Model Decrypt IOException!");
            return null;
        }
    }
}

