/*
 * Decompiled with CFR 0.152.
 */
package cn.aotcloud.smcrypto.util;

import java.io.UnsupportedEncodingException;

public class ByteUtils {
    private static final String HEX_STRING_MAPPING = "0123456789ABCDEF";
    public static final String CHARSET_NAME = "UTF-8";

    public static String bytesToHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (byte by : byArray) {
            int n = by & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static byte[] hexToBytes(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() <= 0) {
            return new byte[0];
        }
        string = string.toUpperCase();
        int n = string.length() / 2;
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            byArray[i] = (byte)(ByteUtils.charToByte(cArray[n2]) << 4 | ByteUtils.charToByte(cArray[n2 + 1]));
        }
        return byArray;
    }

    public static String bytesToString(byte[] byArray) {
        try {
            return new String(byArray, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] stringToBytes(String string) {
        try {
            return string.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String hexToString(String string) {
        return ByteUtils.bytesToString(ByteUtils.hexToBytes(string));
    }

    public static String stringToHex(String string) {
        return ByteUtils.bytesToHex(ByteUtils.stringToBytes(string));
    }

    private static byte charToByte(char c) {
        return (byte)HEX_STRING_MAPPING.indexOf(c);
    }
}

