/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.actuator.starter.actuate;

import cn.aradin.spring.actuator.starter.extension.IOfflineHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

@Endpoint(id="offline", enableByDefault=true)
public class OfflineEndpoint
implements ApplicationContextAware {
    private static final Map<String, String> NO_CONTEXT_MESSAGE = Collections.unmodifiableMap(Collections.singletonMap("message", "No context to shutdown."));
    private static final Map<String, String> SHUTDOWN_MESSAGE = Collections.unmodifiableMap(Collections.singletonMap("message", "Shutting down, bye..."));
    private ConfigurableApplicationContext context;
    private final List<IOfflineHandler> offlineHandlers;

    public OfflineEndpoint(List<IOfflineHandler> handlers) {
        this.offlineHandlers = handlers;
    }

    @ReadOperation
    public Map<String, String> offline() {
        if (this.context == null) {
            return NO_CONTEXT_MESSAGE;
        }
        try {
            Map<String, String> map = SHUTDOWN_MESSAGE;
            return map;
        }
        finally {
            Thread thread = new Thread(this::performShutdown);
            thread.setContextClassLoader(this.getClass().getClassLoader());
            thread.start();
        }
    }

    private void performShutdown() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (CollectionUtils.isNotEmpty(this.offlineHandlers)) {
            this.offlineHandlers.forEach(handler -> handler.offline((ApplicationContext)this.context));
        }
        this.context.close();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (context instanceof ConfigurableApplicationContext) {
            this.context = (ConfigurableApplicationContext)context;
        }
    }
}

