/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.caffeine;

import cn.aradin.spring.caffeine.cache.Caffeineson;
import cn.aradin.spring.caffeine.cache.listener.CaffeinesonRemovalListener;
import cn.aradin.spring.caffeine.manager.CaffeinesonCacheManager;
import cn.aradin.spring.caffeine.manager.VersionCacheManager;
import cn.aradin.spring.caffeine.manager.properties.CaffeinesonProperties;
import cn.aradin.spring.caffeine.manager.stats.CaffeinesonStatsService;
import cn.aradin.spring.caffeine.manager.version.CaffeinesonVersionHandler;
import cn.aradin.version.core.handler.IVersionBroadHandler;
import com.github.benmanes.caffeine.cache.RemovalListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CaffeinesonProperties.class})
public class CaffeinesonConfiguration {
    public static final String CACHE_MANAGER = "caffeinesonCacheManager";

    @Bean
    @ConditionalOnMissingBean
    RemovalListener<Object, Object> removalListener() {
        return new CaffeinesonRemovalListener();
    }

    @Bean
    @ConditionalOnMissingBean
    Caffeineson Caffeineson(CaffeinesonProperties caffeinesonProperties, RemovalListener<Object, Object> removalListener, IVersionBroadHandler versionBroadHandler) {
        return new Caffeineson("caffeineson", caffeinesonProperties.getGroup(), caffeinesonProperties.isVersioned(), caffeinesonProperties.getDefaults(), removalListener, versionBroadHandler);
    }

    @Bean
    VersionCacheManager caffeinesonCacheManager(CaffeinesonProperties caffeinesonProperties, RemovalListener<Object, Object> removalListener, IVersionBroadHandler versionBroadHandler) {
        return new CaffeinesonCacheManager(caffeinesonProperties, removalListener, versionBroadHandler);
    }

    @Bean
    CaffeinesonStatsService caffeinesonStatsService(VersionCacheManager caffeinesonCacheManager) {
        return new CaffeinesonStatsService(caffeinesonCacheManager);
    }

    @Bean
    @ConditionalOnProperty(name={"aradin.cache.caffeine.versioned"}, havingValue="true")
    CaffeinesonVersionHandler caffeinesonVersionHandler(VersionCacheManager caffeinesonCacheManager, CaffeinesonProperties caffeinesonProperties) {
        return new CaffeinesonVersionHandler(caffeinesonCacheManager, caffeinesonProperties);
    }
}

