/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.caffeine.cache;

import cn.aradin.spring.caffeine.cache.config.CaffeinesonConfig;
import cn.aradin.spring.caffeine.cache.listener.CaffeinesonRemovalListener;
import cn.aradin.version.core.handler.IVersionBroadHandler;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;

public class Caffeineson
extends AbstractValueAdaptingCache {
    private static final Logger log = LoggerFactory.getLogger(Caffeineson.class);
    private Cache<Object, Object> caffeineCache;
    private final String name;
    private final boolean versioned;
    private IVersionBroadHandler versionBroadHandler;

    public Caffeineson(String name, CaffeinesonConfig caffeineConfig, IVersionBroadHandler versionBroadHandler) {
        super(caffeineConfig.isAllowNullValues());
        this.name = name;
        this.versioned = caffeineConfig.isVersioned();
        this.versionBroadHandler = versionBroadHandler;
        this.caffeineCache = this.caffeineCache(caffeineConfig, new CaffeinesonRemovalListener(name));
    }

    protected Cache<Object, Object> caffeineCache(CaffeinesonConfig config, RemovalListener<Object, Object> listener) {
        Caffeine cacheBuilder = Caffeine.newBuilder();
        if (config.getExpireAfterAccess() > 0L) {
            cacheBuilder.expireAfterAccess(config.getExpireAfterAccess(), TimeUnit.MILLISECONDS);
        }
        if (config.getExpireAfterWrite() > 0L) {
            cacheBuilder.expireAfterWrite(config.getExpireAfterWrite(), TimeUnit.MILLISECONDS);
        }
        if (config.getInitialCapacity() > 0) {
            cacheBuilder.initialCapacity(config.getInitialCapacity());
        }
        if (config.getMaximumSize() > 0L) {
            cacheBuilder.maximumSize(config.getMaximumSize());
        }
        if (config.getRefreshAfterWrite() > 0L) {
            cacheBuilder.refreshAfterWrite(config.getRefreshAfterWrite(), TimeUnit.MILLISECONDS);
        }
        if (config.isSoft()) {
            cacheBuilder.softValues();
        }
        if (listener != null) {
            cacheBuilder.removalListener(listener);
        }
        if (config.isRecordStats()) {
            cacheBuilder.recordStats();
        }
        if (log.isDebugEnabled()) {
            log.debug("\u521d\u59cb\u5316Caffeine\u5b9e\u4f8b {},\u914d\u7f6e\u4fe1\u606f{}", (Object)this.name, (Object)JSONObject.toJSONString((Object)config, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        return cacheBuilder.build();
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this.caffeineCache;
    }

    public long estimatedSize() {
        return this.caffeineCache.estimatedSize();
    }

    public void cleanUp() {
        this.caffeineCache.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.lookup(key);
        if (value == null) {
            String string = key.toString().intern();
            synchronized (string) {
                try {
                    value = this.lookup(key);
                    if (value != null) {
                        return (T)value;
                    }
                    value = valueLoader.call();
                    this.put(key, this.toStoreValue(value));
                }
                catch (Exception e) {
                    try {
                        Class<?> c = Class.forName("org.springframework.cache.Cache$ValueRetrievalException");
                        Constructor<?> constructor = c.getConstructor(Object.class, Callable.class, Throwable.class);
                        RuntimeException exception = (RuntimeException)constructor.newInstance(key, valueLoader, e.getCause());
                        throw exception;
                    }
                    catch (Exception e1) {
                        throw new IllegalStateException(e1);
                    }
                }
            }
        }
        return (T)value;
    }

    public void put(Object key, Object value) {
        if (log.isDebugEnabled()) {
            log.debug("Cache {} \u66f4\u65b0Key {}", (Object)this.name, key);
        }
        this.caffeineCache.put(key, this.toStoreValue(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object prevValue = this.caffeineCache.getIfPresent(key);
        if (prevValue == null) {
            String string = key.toString().intern();
            synchronized (string) {
                prevValue = this.caffeineCache.getIfPresent(key);
                if (prevValue == null) {
                    this.caffeineCache.put(key, this.toStoreValue(value));
                    prevValue = value;
                }
            }
        }
        return this.toValueWrapper(prevValue);
    }

    public void evict(Object key) {
        if (log.isDebugEnabled()) {
            log.debug("Cache {} \u5220\u9664Key {}", (Object)this.name, key);
        }
        this.caffeineCache.invalidate(key);
        if (this.versioned) {
            this.versionBroadHandler.broadcast(this.name);
        }
    }

    public void clear() {
        this.caffeineCache.invalidateAll();
    }

    protected Object lookup(Object key) {
        return this.caffeineCache.getIfPresent(key);
    }

    public CacheStats stats() {
        return this.caffeineCache.stats();
    }
}

