/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.caffeine.manager.stats;

import cn.aradin.spring.caffeine.cache.Caffeineson;
import cn.aradin.spring.caffeine.manager.VersionCacheManager;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CaffeinesonStatsService {
    private VersionCacheManager cacheManager;

    public CaffeinesonStatsService(VersionCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Map<String, Map<String, Object>> getStats() {
        Collection cacheNames = this.cacheManager.getCacheNames();
        if (cacheNames != null) {
            HashMap<String, Map<String, Object>> statMap = new HashMap<String, Map<String, Object>>();
            for (String cacheName : cacheNames) {
                Caffeineson cache = (Caffeineson)this.cacheManager.getCache(cacheName = cacheName.substring(cacheName.lastIndexOf("#") + 1));
                if (cache == null) continue;
                CacheStats stats = cache.stats();
                HashMap<String, Number> stat = new HashMap<String, Number>();
                stat.put("size", cache.estimatedSize());
                stat.put("evictionCount", stats.evictionCount());
                stat.put("evictionWeight", stats.evictionWeight());
                stat.put("hitCount", stats.hitCount());
                stat.put("missCount", stats.missCount());
                stat.put("hitRate", stats.hitRate());
                stat.put("loadCount", stats.loadCount());
                stat.put("loadFailureCount", stats.loadFailureCount());
                stat.put("loadSuccessCount", stats.loadSuccessCount());
                stat.put("requestCount", stats.requestCount());
                stat.put("totalLoadTime", stats.totalLoadTime());
                stat.put("averageLoadPenalty", stats.averageLoadPenalty());
                stat.put("missRate", stats.missRate());
                statMap.put(cacheName, stat);
            }
            return statMap;
        }
        return null;
    }
}

