/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.caffeine.manager;

import cn.aradin.spring.caffeine.cache.Caffeineson;
import cn.aradin.spring.caffeine.cache.config.CaffeinesonConfig;
import cn.aradin.spring.caffeine.manager.VersionCacheManager;
import cn.aradin.spring.caffeine.manager.properties.CaffeinesonProperties;
import cn.aradin.version.core.handler.IVersionBroadHandler;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class CaffeinesonCacheManager
implements VersionCacheManager {
    private static final Logger log = LoggerFactory.getLogger(CaffeinesonCacheManager.class);
    ConcurrentHashMap<String, Long> versionMap = new ConcurrentHashMap();
    ConcurrentHashMap<String, Caffeineson> instanceMap = new ConcurrentHashMap();
    Map<String, CaffeinesonConfig> configs = new ConcurrentHashMap<String, CaffeinesonConfig>();
    CaffeinesonConfig defaultConfig = new CaffeinesonConfig();
    IVersionBroadHandler versionBroadHandler;
    String versionGroup;
    private Timer timer;

    public CaffeinesonCacheManager(CaffeinesonProperties caffeinesonProperties, IVersionBroadHandler versionBroadHandler) {
        this.configs = caffeinesonProperties.getConfigs();
        if (log.isDebugEnabled()) {
            log.debug("Caffeine Configs :  {}", (Object)JSONObject.toJSONString(this.configs, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        this.defaultConfig = caffeinesonProperties.getDefaults();
        this.versionBroadHandler = versionBroadHandler;
        if (caffeinesonProperties.getCleanInterval() != null) {
            log.info("Start cleanUp timer for interval {} ms", (Object)caffeinesonProperties.getCleanInterval().toMillis());
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (CaffeinesonCacheManager.this.instanceMap != null && CaffeinesonCacheManager.this.instanceMap.size() > 0) {
                        for (String name : CaffeinesonCacheManager.this.instanceMap.keySet()) {
                            Caffeineson cache = CaffeinesonCacheManager.this.instanceMap.get(name);
                            if (cache == null) continue;
                            name = name.substring(name.lastIndexOf("#") + 1);
                            CaffeinesonConfig config = CaffeinesonCacheManager.this.configs.get(name);
                            if (cache.estimatedSize() <= (long)config.getInitialCapacity()) continue;
                            log.info("CleanUp cache {}", (Object)name);
                            try {
                                cache.cleanUp();
                            }
                            catch (Exception e) {
                                log.error("Cache {} cleanUp failed for the reason: {}", (Object)name, (Object)e.getMessage());
                            }
                        }
                    }
                }
            }, 0L, caffeinesonProperties.getCleanInterval().toMillis());
        }
    }

    protected CaffeinesonConfig createCaffeinesonConfig() {
        log.info("\u521b\u5efa\u9ed8\u8ba4Caffeine\u914d\u7f6e");
        return this.defaultConfig;
    }

    protected Caffeineson buildCache(String name) {
        Caffeineson cache;
        long version = this.version(name);
        String exact_name = version + "##" + name;
        Caffeineson oldCache = this.instanceMap.putIfAbsent(exact_name, cache = new Caffeineson(name, this.configs.get(name), this.versionBroadHandler));
        if (oldCache != null) {
            cache = oldCache;
        }
        return cache;
    }

    public Cache getCache(String name) {
        long version = this.version(name);
        String exact_name = version + "##" + name;
        Caffeineson cache = this.instanceMap.get(exact_name);
        if (cache != null) {
            return cache;
        }
        CaffeinesonConfig caffeineconfig = this.configs.get(name);
        if (caffeineconfig == null) {
            caffeineconfig = this.createCaffeinesonConfig();
            this.configs.put(name, caffeineconfig);
        }
        return this.buildCache(name);
    }

    public Collection<String> getCacheNames() {
        return this.instanceMap.keySet();
    }

    @Override
    public void evictVersion(String cacheName, long version) {
        String exact_name = version + "##" + cacheName;
        Caffeineson cache = (Caffeineson)this.getCacheIfExist(exact_name);
        if (cache != null) {
            cache.clear();
            this.instanceMap.remove(exact_name);
        }
    }

    @Override
    public void evict(String cacheName) {
        long version = this.versionMap.get(cacheName);
        this.evictVersion(cacheName, version);
    }

    @Override
    public long version(String cacheName) {
        Long version = this.versionMap.get(cacheName);
        return version == null ? 0L : version;
    }

    @Override
    public void version(String cacheName, long version) {
        long lastVersion = this.version(cacheName);
        if (log.isDebugEnabled()) {
            log.debug("\u66f4\u65b0\u7248\u672c {} \u5230 {}", (Object)lastVersion, (Object)version);
        }
        this.evictVersion(cacheName, lastVersion);
        this.versionMap.put(cacheName, version);
    }

    @Override
    public void init(String cacheName, long version) {
        Long cur_version;
        if (log.isDebugEnabled()) {
            log.debug("\u521d\u59cb\u5316\u7248\u672c {}", (Object)version);
        }
        if ((cur_version = this.versionMap.get(cacheName)) == null) {
            this.versionMap.put(cacheName, version);
        }
    }

    @Override
    public Cache getCacheIfExist(String cacheName) {
        return (Cache)this.instanceMap.get(cacheName);
    }
}

