/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.salarm.starter;

import cn.aradin.spring.redis.starter.AradinRedisAutoConfiguration;
import cn.aradin.spring.salarm.starter.handler.DefaultSalarmHandlerImpl;
import cn.aradin.spring.salarm.starter.handler.ISalarmHandler;
import cn.aradin.spring.salarm.starter.notifier.ISalarm;
import cn.aradin.spring.salarm.starter.notifier.SalarmImpl;
import cn.aradin.spring.salarm.starter.properties.SalarmProperties;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@AutoConfigureAfter(value={AradinRedisAutoConfiguration.class})
@EnableConfigurationProperties(value={SalarmProperties.class})
public class AradinSalarmAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ISalarmHandler defautlSalarmHandler() {
        return new DefaultSalarmHandlerImpl();
    }

    @Bean
    @ConditionalOnBean(value={RedisTemplate.class})
    public ISalarm salarm(RedisTemplate<Object, Object> redisTemplate, SalarmProperties salarmProperties, List<ISalarmHandler> handlers) {
        return new SalarmImpl(redisTemplate, salarmProperties, handlers);
    }
}

