/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.swagger.starter;

import cn.aradin.spring.swagger.starter.properties.SwaggerProperties;
import com.github.xiaoymin.swaggerbootstrapui.annotations.EnableSwaggerBootstrapUI;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableConfigurationProperties(value={SwaggerProperties.class})
@EnableSwagger2
@EnableSwaggerBootstrapUI
public class AradinSwaggerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AradinSwaggerAutoConfiguration.class);
    @Autowired
    private SwaggerProperties swaggerProperties;

    public AradinSwaggerAutoConfiguration() {
        log.debug("SwaggerAutoConfiguration \u521d\u59cb\u5316");
    }

    @Bean
    public Docket api() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).useDefaultResponseMessages(this.swaggerProperties.getUseDefaultStatus().booleanValue()).enable(this.swaggerProperties.getEnable().booleanValue());
        ApiSelectorBuilder builder = docket.select();
        builder = builder.apis(Predicates.or(this.apisFilter()));
        if (StringUtils.isNotEmpty((CharSequence)this.swaggerProperties.getAntPath())) {
            builder = builder.paths(PathSelectors.ant((String)this.swaggerProperties.getAntPath()));
        }
        return builder.build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).version(this.swaggerProperties.getVersion()).licenseUrl(this.swaggerProperties.getLicenseUrl()).contact(new Contact(this.swaggerProperties.getContactName(), this.swaggerProperties.getContactUrl(), this.swaggerProperties.getContactEmail())).build();
    }

    private List<Predicate<RequestHandler>> apisFilter() {
        String[] basePackages;
        ArrayList<Predicate<RequestHandler>> apis = new ArrayList<Predicate<RequestHandler>>();
        String basePackageStr = this.swaggerProperties.getBasePackage();
        if (StringUtils.isNotEmpty((CharSequence)basePackageStr) && null != (basePackages = basePackageStr.split(";")) && basePackages.length > 0) {
            Predicate predicate = input -> {
                Class declaringClass = input.declaringClass();
                String packageName = declaringClass.getPackage().getName();
                return Arrays.asList(basePackages).contains(packageName);
            };
            apis.add((Predicate<RequestHandler>)predicate);
        }
        return apis;
    }

    List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "\u8ba4\u8bc1\u6743\u9650");
        return Lists.newArrayList((Object[])new SecurityReference[]{new SecurityReference("Authorization", new AuthorizationScope[]{authorizationScope})});
    }
}

