/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.velocity.starter;

import cn.aradin.spring.velocity.servlet.EmbeddedVelocityViewResolver;
import cn.aradin.spring.velocity.starter.properties.VelocityProperties;
import cn.aradin.spring.velocity.ui.VelocityEngineFactory;
import cn.aradin.spring.velocity.ui.VelocityEngineFactoryBean;
import cn.aradin.spring.velocity.view.VelocityConfig;
import cn.aradin.spring.velocity.view.VelocityConfigurer;
import jakarta.servlet.Servlet;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.servlet.resource.ResourceUrlEncodingFilter;

@Configuration
@ConditionalOnClass(value={VelocityEngine.class, VelocityEngineFactory.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={VelocityProperties.class})
public class AradinVelocityAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AradinVelocityAutoConfiguration.class);
    private final ApplicationContext applicationContext;
    private final VelocityProperties properties;

    public AradinVelocityAutoConfiguration(ApplicationContext applicationContext, VelocityProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @PostConstruct
    public void checkTemplateLocationExists() {
        TemplateLocation location;
        if (this.properties.isCheckTemplateLocation() && !(location = new TemplateLocation(this.properties.getResourceLoaderPath())).exists((ResourcePatternResolver)this.applicationContext)) {
            log.warn("Cannot find template location: " + location + " (please add some templates, check your Velocity configuration, or set spring.velocity.checkTemplateLocation=false)");
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class})
    @ConditionalOnWebApplication
    public static class VelocityWebConfiguration
    extends VelocityConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={VelocityConfig.class})
        public VelocityConfigurer velocityConfigurer() {
            VelocityConfigurer configurer = new VelocityConfigurer();
            this.applyProperties((VelocityEngineFactory)configurer);
            return configurer;
        }

        @Bean
        public VelocityEngine velocityEngine(VelocityConfigurer configurer) throws VelocityException, IOException {
            return configurer.getVelocityEngine();
        }

        @Bean
        @ConditionalOnMissingBean(name={"velocityViewResolver"})
        @ConditionalOnProperty(name={"spring.velocity.enabled"}, matchIfMissing=true)
        public EmbeddedVelocityViewResolver velocityViewResolver() {
            EmbeddedVelocityViewResolver resolver = new EmbeddedVelocityViewResolver();
            this.properties.applyToMvcViewResolver(resolver);
            return resolver;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledResourceChain
        public ResourceUrlEncodingFilter resourceUrlEncodingFilter() {
            return new ResourceUrlEncodingFilter();
        }
    }

    @Configuration
    @ConditionalOnNotWebApplication
    public static class VelocityNonWebConfiguration
    extends VelocityConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public VelocityEngineFactoryBean velocityConfiguration() {
            VelocityEngineFactoryBean velocityEngineFactoryBean = new VelocityEngineFactoryBean();
            this.applyProperties((VelocityEngineFactory)velocityEngineFactoryBean);
            return velocityEngineFactoryBean;
        }
    }

    protected static class VelocityConfiguration {
        @Autowired
        protected VelocityProperties properties;

        protected VelocityConfiguration() {
        }

        protected void applyProperties(VelocityEngineFactory factory) {
            if (!this.properties.getResourceLoaderPath().contains("classpath:/templates")) {
                this.properties.setResourceLoaderPath(this.properties.getResourceLoaderPath() + ",classpath:/templates/");
            }
            factory.setResourceLoaderPath(this.properties.getResourceLoaderPath());
            factory.setPreferFileSystemAccess(this.properties.isPreferFileSystemAccess());
            Properties velocityProperties = new Properties();
            velocityProperties.setProperty("input.encoding", this.properties.getCharsetName());
            velocityProperties.setProperty("output.encoding", this.properties.getCharsetName());
            velocityProperties.putAll(this.properties.getProperties());
            factory.setVelocityProperties(velocityProperties);
        }
    }
}

