/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.velocity.servlet;

import cn.aradin.spring.velocity.view.VelocityToolboxView;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.ViewToolContext;
import org.apache.velocity.tools.view.ViewToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.core.io.ClassPathResource;

public class EmbeddedVelocityToolboxView
extends VelocityToolboxView {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedVelocityToolboxView.class);

    @Override
    protected Context createVelocityContext(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ViewToolContext context = new ViewToolContext(this.getVelocityEngine(), request, response, this.getToolboxConfigFileAwareServletContext());
        if (this.getToolboxConfigLocation() != null) {
            ViewToolManager toolManager = new ViewToolManager(this.getToolboxConfigFileAwareServletContext(), false, false);
            toolManager.configure(this.getToolboxConfigLocation());
            context.addToolbox(toolManager.getApplicationToolbox());
        }
        return context;
    }

    private ServletContext getToolboxConfigFileAwareServletContext() {
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget((Object)this.getServletContext());
        factory.addAdvice((Advice)new GetResourceMethodInterceptor(this.getToolboxConfigLocation()));
        return (ServletContext)factory.getProxy(((Object)((Object)this)).getClass().getClassLoader());
    }

    private static class GetResourceMethodInterceptor
    implements MethodInterceptor {
        private final String toolboxFile;

        GetResourceMethodInterceptor(String toolboxFile) {
            if (log.isDebugEnabled()) {
                log.debug("Find toolboxFile {}", toolboxFile);
            }
            if (toolboxFile != null && !((String)toolboxFile).startsWith("/")) {
                toolboxFile = "/" + (String)toolboxFile;
            }
            this.toolboxFile = toolboxFile;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().getName().equals("getResourceAsStream") && invocation.getArguments()[0].equals(this.toolboxFile)) {
                InputStream inputStream = (InputStream)invocation.proceed();
                if (inputStream == null) {
                    try {
                        inputStream = new ClassPathResource(this.toolboxFile, Thread.currentThread().getContextClassLoader()).getInputStream();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return inputStream;
            }
            return invocation.proceed();
        }
    }
}

