/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.velocity.view;

import cn.aradin.spring.velocity.view.VelocityToolboxView;
import cn.aradin.spring.velocity.view.VelocityView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class VelocityViewResolver
extends AbstractTemplateViewResolver {
    private static final Logger log = LoggerFactory.getLogger(VelocityViewResolver.class);
    private String dateToolAttribute;
    private String numberToolAttribute;
    private String toolboxConfigLocation;

    public VelocityViewResolver() {
        this.setViewClass(this.requiredViewClass());
    }

    protected Class<?> requiredViewClass() {
        return VelocityView.class;
    }

    public void setDateToolAttribute(String dateToolAttribute) {
        this.dateToolAttribute = dateToolAttribute;
    }

    public void setNumberToolAttribute(String numberToolAttribute) {
        this.numberToolAttribute = numberToolAttribute;
    }

    public void setToolboxConfigLocation(String toolboxConfigLocation) {
        this.toolboxConfigLocation = toolboxConfigLocation;
    }

    protected void initApplicationContext() {
        super.initApplicationContext();
        if (this.toolboxConfigLocation != null) {
            if (VelocityView.class == this.getViewClass()) {
                this.logger.info((Object)"Using VelocityToolboxView instead of default VelocityView due to specified toolboxConfigLocation");
                this.setViewClass(VelocityToolboxView.class);
            } else if (!VelocityToolboxView.class.isAssignableFrom(this.getViewClass())) {
                throw new IllegalArgumentException("Given view class [" + this.getViewClass().getName() + "] is not of type [" + VelocityToolboxView.class.getName() + "], which it needs to be in case of a specified toolboxConfigLocation");
            }
        }
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        VelocityView view = (VelocityView)super.buildView(viewName);
        view.setDateToolAttribute(this.dateToolAttribute);
        view.setNumberToolAttribute(this.numberToolAttribute);
        if (this.toolboxConfigLocation != null) {
            if (log.isDebugEnabled()) {
                log.debug("\u521d\u59cb\u5316toolBox {} {}", (Object)this.toolboxConfigLocation, (Object)viewName);
            }
            ((VelocityToolboxView)view).setToolboxConfigLocation(this.toolboxConfigLocation);
        }
        return view;
    }
}

