/*
 * Decompiled with CFR 0.152.
 */
package bee.service.config;

import bee.cloud.service.base.work.AppServices;
import bee.tool.Tool;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Component;

@Component
public class NacosClient
implements AppServices {
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${nacos.host}")
    private String serverAddr;
    @Value(value="${nacos.namespace:public}")
    private String namespace;
    @Autowired(required=false)
    private NacosConfigManager configManager;
    @Autowired(required=false)
    private NacosServiceManager nacosServiceManager;
    @Autowired(required=false)
    private DiscoveryClient disClient;
    private ConfigService configService;
    private Map<String, Set<AppServices.Instance>> instances = new TreeMap<String, Set<AppServices.Instance>>();

    protected List<ServiceInstance> getServiceInstances() {
        return this.disClient.getInstances(this.applicationName);
    }

    public NamingService getNamingService() {
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        properties.put("namespace", this.namespace);
        return this.nacosServiceManager.getNamingService(properties);
    }

    public Set<String> getService() {
        if (this.disClient == null) {
            return null;
        }
        List services = this.disClient.getServices();
        TreeSet<String> sets = new TreeSet<String>((o1, o2) -> o1.compareTo((String)o2));
        sets.addAll(services);
        sets.remove(this.applicationName);
        return sets;
    }

    public List<ServiceInstance> getService(String serviceId) {
        return this.disClient.getInstances(serviceId);
    }

    public ConfigService getConfigService() throws NacosException {
        if (this.configManager == null) {
            Tool.Log.warn((String)"Nacos\u914d\u7f6e\u7ba1\u7406\u4e2d\u5fc3\u4e3a\u7a7a\uff0c\u83b7\u53d6\u4e0d\u4e86\u914d\u7f6e\u6587\u4ef6\uff01");
            return null;
        }
        if (this.configService == null) {
            this.configService = this.configManager.getConfigService();
        }
        return this.configService;
    }

    public Map<String, Set<AppServices.Instance>> getInstances() {
        return this.instances;
    }

    public void addInstance(AppServices.Instance instance) {
        Set<AppServices.Instance> set = this.instances.get(instance.getServiceId());
        if (Tool.noEmpty(set)) {
            set.add(instance);
        } else {
            set = new HashSet<AppServices.Instance>();
            set.add(instance);
            this.instances.put(instance.getServiceId(), set);
        }
    }

    public void removeInstance(AppServices.Instance instance) {
        Set<AppServices.Instance> set = this.instances.get(instance.getServiceId());
        if (Tool.noEmpty(set)) {
            for (AppServices.Instance ins : set) {
                if (!instance.getHost().equals(ins.getHost()) || instance.getPort() != ins.getPort()) continue;
                set.remove(ins);
                break;
            }
        }
    }

    public boolean isSelf(String serviceId) {
        return this.applicationName.equals(serviceId);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

