/*
 * Decompiled with CFR 0.152.
 */
package bee.service.config;

import bee.cloud.service.base.work.Work;
import bee.service.config.NacosClient;
import bee.tool.Tool;
import bee.tool.string.Format;
import bee.tool.string.MD5;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class NacosConfig
implements Work.FlushConfig {
    @Autowired
    private NacosClient client;
    private String group = "DEFAULT_GROUP";
    private String dataId;
    private boolean enable = true;
    private String preSign = null;
    private String content;

    public abstract void getConfig(String var1);

    private void setConfig(String content) {
        this.content = content;
    }

    public void init() {
        try {
            if (!this.enable || Format.isEmpty((String)this.dataId)) {
                return;
            }
            ConfigService configService = this.client.getConfigService();
            if (configService == null) {
                return;
            }
            String content = configService.getConfigAndSignListener(this.dataId, this.group, 5000L, new Listener(){

                public Executor getExecutor() {
                    return t -> t.run();
                }

                public void receiveConfigInfo(String configInfo) {
                    String sign = MD5.encode((String)configInfo);
                    if (sign.equals(NacosConfig.this.preSign)) {
                        return;
                    }
                    NacosConfig.this.preSign = sign;
                    Thread.currentThread().setName("bee_nacos");
                    Tool.Log.info((String)"Nacos\u914d\u7f6e\u6587\u4ef6\u66f4\u65b0\uff0c\u5206\u7ec4\uff1a{}\uff0c\u6587\u4ef6\uff1a{}", (Object[])new Object[]{NacosConfig.this.group, NacosConfig.this.dataId});
                    NacosConfig.this.setConfig(configInfo);
                    NacosConfig.this.getConfig(configInfo);
                }
            });
            this.setConfig(content);
            this.getConfig(content);
        }
        catch (NacosException e) {
            Tool.Log.error((Throwable)e);
        }
    }

    public void flush() {
        String newContent = String.valueOf(this.content) + "\n#" + System.currentTimeMillis();
        try {
            ConfigService configService = this.client.getConfigService();
            configService.publishConfig(this.dataId, this.group, newContent);
        }
        catch (NacosException e) {
            Tool.Log.error((Throwable)e);
        }
    }

    public NacosClient getClient() {
        return this.client;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDataId() {
        return this.dataId;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getPreSign() {
        return this.preSign;
    }

    public String getContent() {
        return this.content;
    }

    public void setClient(NacosClient client) {
        this.client = client;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setPreSign(String preSign) {
        this.preSign = preSign;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NacosConfig)) {
            return false;
        }
        NacosConfig other = (NacosConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        NacosClient this$client = this.getClient();
        NacosClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$dataId = this.getDataId();
        String other$dataId = other.getDataId();
        if (this$dataId == null ? other$dataId != null : !this$dataId.equals(other$dataId)) {
            return false;
        }
        String this$preSign = this.getPreSign();
        String other$preSign = other.getPreSign();
        if (this$preSign == null ? other$preSign != null : !this$preSign.equals(other$preSign)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NacosConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        NacosClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $dataId = this.getDataId();
        result = result * 59 + ($dataId == null ? 43 : $dataId.hashCode());
        String $preSign = this.getPreSign();
        result = result * 59 + ($preSign == null ? 43 : $preSign.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "NacosConfig(client=" + this.getClient() + ", group=" + this.getGroup() + ", dataId=" + this.getDataId() + ", enable=" + this.isEnable() + ", preSign=" + this.getPreSign() + ", content=" + this.getContent() + ")";
    }
}

