/*
 * Decompiled with CFR 0.152.
 */
package bee.service.config;

import bee.cloud.core.db.RequestParam;
import bee.cloud.ri.http.Http;
import bee.cloud.ri.http.HttpClient;
import bee.cloud.ri.http.HttpClients;
import bee.cloud.service.base.work.Service;
import bee.service.config.NacosClient;
import bee.tool.Tool;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.annotation.NacosInjected;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Service;

@Service
public class NacosService
implements bee.cloud.service.base.work.Service {
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${server.port}")
    private int port;
    @Value(value="${nacos.host}")
    private String serverAddr;
    @Value(value="${nacos.namespace:public}")
    private String namespace;
    @Value(value="${nacos.group:DEFAULT_GROUP}")
    private String group;
    @NacosInjected
    private NamingService naming;
    @Autowired
    private NacosClient client;
    private Instance self;
    private static String URL_INSTANCE = "http://{nacos_address}/nacos/v1/ns/instance?serviceName={service_name}&ip={ip}&port={port}&ephemeral=false&namespaceId={namespace}";
    private static HttpClient httpClient = HttpClients.getHttpClient();
    private static String URL = "http://{ip}:{port}/{uri}";
    private static String localIP = Tool.getLocalIP();

    public void online() {
        try {
            Instance ins = this.getOneInstance();
            if (ins != null) {
                ins.setHealthy(true);
                ins.setEnabled(true);
            }
            this.naming.registerInstance(this.applicationName, ins);
        }
        catch (NacosException e) {
            Tool.Log.error((Throwable)e);
        }
    }

    public void offline() {
        try {
            Instance ins = this.getOneInstance();
            if (ins == null) {
                return;
            }
            ins.setHealthy(false);
            ins.setEnabled(false);
        }
        catch (NacosException e) {
            Tool.Log.error((Throwable)e);
        }
    }

    public void register() {
    }

    private Instance getOneInstance() throws NacosException {
        if (this.self != null) {
            return this.self;
        }
        List<ServiceInstance> service = this.client.getServiceInstances();
        if (service == null || service.isEmpty()) {
            return null;
        }
        String localIP = Tool.getLocalIP();
        ServiceInstance si = null;
        for (ServiceInstance ins : service) {
            if (localIP.indexOf(ins.getHost()) < 0) continue;
            si = ins;
            break;
        }
        if (si == null) {
            return null;
        }
        Instance instance = new Instance();
        instance.setIp(si.getHost());
        instance.setPort(si.getPort());
        instance.setHealthy(true);
        instance.setEnabled(true);
        instance.setServiceName(si.getServiceId());
        instance.setInstanceId(Tool.getUUID());
        this.self = instance;
        return this.self;
    }

    public NamingService getNaming() {
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        properties.put("namespace", this.namespace);
        try {
            this.naming = NacosFactory.createNamingService((Properties)properties);
            return this.naming;
        }
        catch (NacosException e) {
            return null;
        }
    }

    public List<Service.Host> getHosts() {
        ArrayList<Service.Host> hosts = new ArrayList<Service.Host>();
        Set<String> service = this.client.getService();
        if (service == null || service.isEmpty()) {
            return hosts;
        }
        for (String s : service) {
            List<ServiceInstance> ins = this.client.getService(s);
            for (ServiceInstance si : ins) {
                String ip = si.getHost();
                int port = si.getPort();
                Service.Host host = new Service.Host();
                host.setIp(ip);
                host.setPort(port);
                hosts.add(host);
            }
        }
        return hosts;
    }

    public List<Service.Host> getInstance() {
        ArrayList<Service.Host> hosts = new ArrayList<Service.Host>();
        List<ServiceInstance> ins = this.client.getServiceInstances();
        for (ServiceInstance si : ins) {
            String ip = si.getHost();
            int port = si.getPort();
            Service.Host host = new Service.Host();
            host.setIp(ip);
            host.setPort(port);
            host.setCurrent(ip.equals(Tool.getLocalIP()) && port == this.port);
            hosts.add(host);
        }
        return hosts;
    }

    public void broadcast(RequestParam param) {
        if (param.header.has("broadcast")) {
            return;
        }
        List<ServiceInstance> ins = this.client.getService(this.applicationName);
        for (ServiceInstance si : ins) {
            if (localIP.indexOf(si.getHost()) >= 0 && si.getPort() == this.port) continue;
            String ip = si.getHost();
            int port = si.getPort();
            String url = URL.replace("{ip}", ip).replace("{port}", "" + port).replace("{uri}", param.header.getUri());
            Http http = httpClient.createHttp(url, Http.Method.valueOf((String)param.header.getMethod().toUpperCase()));
            http.setHeader("broadcast", Tool.MD5.encode((String)this.applicationName));
            http.setJsonParams(param.getRootNode());
            Http.Response res = http.execute();
            Tool.Log.info((String)"result:{}", (Object[])new Object[]{res.toString()});
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public int getPort() {
        return this.port;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Instance getSelf() {
        return this.self;
    }
}

