/*
 * Decompiled with CFR 0.152.
 */
package bee.service.config;

import bee.service.config.NacosClient;
import bee.tool.Tool;
import com.alibaba.nacos.api.config.ConfigChangeEvent;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.listener.impl.AbstractConfigChangeListener;
import com.purgeteam.dynamic.config.starter.annotation.EnableDynamicConfigEvent;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

@EnableDynamicConfigEvent
@Resource
public class YamlConfig {
    @Autowired
    private NacosClient client;
    @Value(value="${spring.cloud.nacos.config.server-addr}")
    private String serverAddr;
    @Value(value="${spring.cloud.nacos.config.namespace}")
    private String namespace;
    @Value(value="${spring.cloud.nacos.config.group}")
    private String group;

    @Bean
    public void init() {
        try {
            ConfigService configService = this.client.getConfigService();
            if (configService == null) {
                return;
            }
            configService.addListener("*.yml", this.group, (Listener)new AbstractConfigChangeListener(){

                public void receiveConfigChange(ConfigChangeEvent event) {
                    Collection changeItems = event.getChangeItems();
                }

                public void receiveConfigInfo(String configInfo) {
                    super.receiveConfigInfo(configInfo);
                }
            });
        }
        catch (NacosException e) {
            Tool.Log.error((Throwable)e);
        }
    }
}

