/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.data;

import cn.bestwu.framework.data.SearchRepository;
import cn.bestwu.framework.data.annotation.HighLight;
import cn.bestwu.framework.data.util.EntityManagerUtil;
import cn.bestwu.framework.event.BeforeSearchEvent;
import cn.bestwu.framework.event.SearchResultEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Transactional(readOnly=true)
public class JpaSearchRepository
implements SearchRepository {
    private Logger logger = LoggerFactory.getLogger(JpaSearchRepository.class);
    private Formatter defaultFormatter = new SimpleHTMLFormatter("<font color=\"#ff0000\">", "</font>");
    private Map<Class, String[]> fieldsCache = new HashMap<Class, String[]>();
    private Map<Class, String[]> highLightFieldsCache = new HashMap<Class, String[]>();
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ApplicationEventPublisher publisher;

    public void setDefaultFormatter(Formatter defaultFormatter) {
        this.defaultFormatter = defaultFormatter;
    }

    @Override
    public <T> Page search(Class<T> modelType, String keyword, Pageable pageable, boolean highLight) {
        String[] fieldArray = this.getSearchFields(modelType);
        return this.search(modelType, keyword, pageable, fieldArray, (searchFactory, query, result) -> {
            if (highLight) {
                String[] highLightFieldArray = this.getHighLightFields(modelType);
                if (highLightFieldArray == null) {
                    highLightFieldArray = fieldArray;
                }
                this.highLight(query, searchFactory.getAnalyzer(modelType), result, modelType, highLightFieldArray);
            } else {
                result.forEach(t -> this.publisher.publishEvent((ApplicationEvent)new SearchResultEvent(t)));
            }
        });
    }

    @Override
    public <T> Page<T> search(Class<T> modelType, String keyword, Pageable pageable, String[] fieldArray) {
        return this.search(modelType, keyword, pageable, fieldArray, null);
    }

    private <T> Page<T> search(Class<T> modelType, String keyword, Pageable pageable, String[] fieldArray, ResultHandler<T> handleResult) {
        long totalSize;
        List result;
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
        SearchFactory searchFactory = fullTextEntityManager.getSearchFactory();
        QueryBuilder queryBuilder = searchFactory.buildQueryBuilder().forEntity(modelType).get();
        TermMatchingContext termMatchingContext = queryBuilder.keyword().onFields(fieldArray);
        Query luceneQuery = termMatchingContext.matching((Object)keyword).createQuery();
        FullTextQuery jpaQuery = fullTextEntityManager.createFullTextQuery(luceneQuery, new Class[]{modelType});
        Criteria criteria = EntityManagerUtil.getSession(this.entityManager).createCriteria(modelType);
        this.publisher.publishEvent((ApplicationEvent)new BeforeSearchEvent(criteria, modelType));
        boolean noCriterionEntries = criteria.toString().contains("[][]");
        if (!noCriterionEntries) {
            jpaQuery.setCriteriaQuery(criteria);
        }
        jpaQuery.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        jpaQuery.setMaxResults(pageable.getPageSize());
        org.springframework.data.domain.Sort sort = pageable.getSort();
        if (sort != null) {
            ArrayList sortFields = new ArrayList();
            sort.forEach(order -> new SortField(order.getProperty(), SortField.Type.SCORE, Sort.Direction.DESC.equals((Object)order.getDirection())));
            jpaQuery.setSort(new Sort(sortFields.toArray(new SortField[sortFields.size()])));
        }
        if ((result = jpaQuery.getResultList()).size() == 0) {
            totalSize = 0L;
        } else if (noCriterionEntries) {
            totalSize = jpaQuery.getResultSize();
        } else {
            criteria.setProjection((Projection)Projections.count((String)"id"));
            totalSize = (Long)criteria.list().get(0);
        }
        if (handleResult != null) {
            handleResult.accept(searchFactory, luceneQuery, result);
        }
        return new PageImpl(result, pageable, totalSize);
    }

    private <T> String[] getHighLightFields(Class<T> modelType) {
        String[] highLightFieldArray = null;
        if (this.highLightFieldsCache.containsKey(modelType)) {
            highLightFieldArray = this.highLightFieldsCache.get(modelType);
        } else {
            HashSet fields = new HashSet();
            Arrays.stream(modelType.getDeclaredFields()).forEach(field -> {
                if (field.isAnnotationPresent(HighLight.class)) {
                    fields.add(field.getName());
                }
            });
            if (!fields.isEmpty()) {
                highLightFieldArray = fields.toArray(new String[fields.size()]);
                this.highLightFieldsCache.put(modelType, highLightFieldArray);
            }
        }
        return highLightFieldArray;
    }

    private <T> String[] getSearchFields(Class<T> modelType) {
        String[] fieldArray;
        if (this.fieldsCache.containsKey(modelType)) {
            fieldArray = this.fieldsCache.get(modelType);
        } else {
            HashSet fields = new HashSet();
            Arrays.stream(modelType.getDeclaredFields()).forEach(field -> {
                if (field.isAnnotationPresent(Field.class)) {
                    fields.add(field.getName());
                }
            });
            fieldArray = fields.toArray(new String[fields.size()]);
            this.fieldsCache.put(modelType, fieldArray);
        }
        return fieldArray;
    }

    private <T> void highLight(Query query, Analyzer analyzer, List<T> data, Class<T> modelType, String ... fields) {
        QueryScorer queryScorer = new QueryScorer(query);
        Highlighter highlighter = new Highlighter(this.defaultFormatter, (Scorer)queryScorer);
        for (T t : data) {
            this.publisher.publishEvent((ApplicationEvent)new SearchResultEvent(t));
            for (String fieldName : fields) {
                try {
                    Object fieldValue = ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(modelType, (String)fieldName).getReadMethod(), t);
                    String highLightFieldValue = highlighter.getBestFragment(analyzer, fieldName, String.valueOf(fieldValue));
                    if (highLightFieldValue == null) continue;
                    ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(modelType, (String)fieldName).getWriteMethod(), t, (Object[])new Object[]{highLightFieldValue});
                }
                catch (Exception e) {
                    this.logger.error("\u9ad8\u4eae\u663e\u793a\u5173\u952e\u5b57\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface ResultHandler<T> {
        public void accept(SearchFactory var1, Query var2, List<T> var3);
    }
}

