/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.data;

import cn.bestwu.framework.data.SearchRepository;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.repository.support.Repositories;

public class MongodbSearchRepository
implements SearchRepository {
    @Autowired
    private Repositories repositories;
    private Logger logger = LoggerFactory.getLogger(MongodbSearchRepository.class);

    @Override
    public <T> Page search(Class<T> modelType, String keyword, Pageable pageable, boolean highLight) {
        Class repositoryInterface = this.repositories.getRepositoryInformationFor(modelType).getRepositoryInterface();
        try {
            Method method = repositoryInterface.getMethod("findAllBy", TextCriteria.class, Pageable.class);
            TextCriteria criteria = TextCriteria.forDefaultLanguage().matchingPhrase(keyword);
            return (Page)method.invoke(this.repositories.getRepositoryFor(modelType), criteria, pageable);
        }
        catch (NoSuchMethodException e) {
            throw new ResourceNotFoundException();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new PageImpl(Collections.emptyList());
        }
    }

    @Override
    public <T> Page<T> search(Class<T> modelType, String keyword, Pageable pageable, String[] fieldArray) {
        return null;
    }
}

