/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.aspect;

import cn.bestwu.framework.rest.controller.BaseController;
import cn.bestwu.framework.rest.support.PrincipalNamePutEvent;
import cn.bestwu.framework.rest.support.RequestJsonViewResponseBodyAdvice;
import cn.bestwu.framework.rest.support.Resource;
import cn.bestwu.framework.rest.support.ResourceUtil;
import cn.bestwu.framework.util.StringUtil;
import java.util.Map;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.ServletServerHttpRequest;

@Aspect
public class LogAspect
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(LogAspect.class);
    private final String PUT_PARAMETER_MAP = "PUT_PARAMETER_MAP";
    private final String PRINCIPAL_NAME = "PRINCIPAL_NAME";
    protected ApplicationEventPublisher publisher;
    @Autowired(required=false)
    private RequestJsonViewResponseBodyAdvice requestJsonViewResponseBodyAdvice;

    public LogAspect(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @AfterThrowing(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void afterThrowing() {
        Resource<String> source = new Resource<String>();
        this.publisher.publishEvent((ApplicationEvent)new PrincipalNamePutEvent(source));
        this.request.setAttribute("PRINCIPAL_NAME", (Object)source.getContent());
        if ("PUT".equals(this.request.getMethod())) {
            this.request.setAttribute("PUT_PARAMETER_MAP", (Object)this.request.getParameterMap());
        }
    }

    @AfterReturning(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)", returning="result")
    public void log(Object result) {
        if (this.logger.isInfoEnabled()) {
            Map parameterMap;
            Object principalName;
            String ipAddress = this.request.getRemoteAddr();
            Object servletPath = this.request.getAttribute("javax.servlet.forward.servlet_path");
            if (servletPath == null) {
                servletPath = this.request.getServletPath();
            }
            if ((principalName = this.request.getAttribute("PRINCIPAL_NAME")) == null) {
                Resource<String> source = new Resource<String>();
                this.publisher.publishEvent((ApplicationEvent)new PrincipalNamePutEvent(source));
                principalName = source.getContent();
            }
            String requestMethod = this.request.getMethod();
            try {
                Map putParameterMap;
                parameterMap = this.request.getParameterMap();
                if ("PUT".equals(requestMethod) && (putParameterMap = (Map)this.request.getAttribute("PUT_PARAMETER_MAP")) != null) {
                    parameterMap.putAll(putParameterMap);
                }
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u51fa\u9519", (Throwable)e);
                }
                parameterMap = null;
            }
            ServletServerHttpRequest servletServerHttpRequest = new ServletServerHttpRequest(this.request);
            HttpHeaders headers = servletServerHttpRequest.getHeaders();
            String MSG_CODE = "{} \u7684 [{}] {} {} \nrequest headers:\n{} \nrequest parameters:\n{} \nresponse:\n{}";
            if (this.logger.isDebugEnabled()) {
                String resultStr;
                String requestSignature = ResourceUtil.getRequestSignature(this.request);
                if ("GET_LOGS_INDEX".equals(requestSignature)) {
                    resultStr = StringUtil.subString(result.toString(), 100);
                } else {
                    if (this.requestJsonViewResponseBodyAdvice != null) {
                        MappingJacksonValue mappingJacksonValue = new MappingJacksonValue(result);
                        this.requestJsonViewResponseBodyAdvice.beforeBodyWrite(mappingJacksonValue, this.request);
                        result = mappingJacksonValue;
                    }
                    resultStr = StringUtil.valueOf(result, true);
                }
                Object[] objectArray = new Object[7];
                objectArray[0] = ipAddress;
                objectArray[1] = principalName == null ? (this.request.getRemoteUser() == null ? "anonymousUser" : this.request.getRemoteUser()) : principalName;
                objectArray[2] = requestMethod;
                objectArray[3] = servletPath;
                objectArray[4] = StringUtil.valueOf(headers, true);
                objectArray[5] = StringUtil.valueOf(parameterMap, true);
                objectArray[6] = resultStr;
                this.logger.info(MSG_CODE, objectArray);
            } else {
                Object[] objectArray = new Object[7];
                objectArray[0] = ipAddress;
                objectArray[1] = principalName == null ? (this.request.getRemoteUser() == null ? "anonymousUser" : this.request.getRemoteUser()) : principalName;
                objectArray[2] = requestMethod;
                objectArray[3] = servletPath;
                objectArray[4] = StringUtil.valueOf(headers, true);
                objectArray[5] = StringUtil.subString(StringUtil.valueOf(parameterMap), 100);
                objectArray[6] = StringUtil.subString(String.valueOf(result), 100);
                this.logger.info(MSG_CODE, objectArray);
            }
        }
    }
}

