/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.controller;

import cn.bestwu.framework.event.AddLinkEvent;
import cn.bestwu.framework.event.DefaultSortEvent;
import cn.bestwu.framework.event.SelfRelEvent;
import cn.bestwu.framework.rest.support.PersistentEntityResource;
import cn.bestwu.framework.rest.support.Response;
import cn.bestwu.framework.util.StringUtil;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.hateoas.Link;

public abstract class BaseController
extends Response {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BASE_NAME = "{repository}";
    public static final String ID_URI = "/{id}";
    static final String BASE_URI = "/{repository}";
    @Autowired(required=false)
    private ServletContext servletContext;
    @Autowired
    private MessageSource messageSource;
    @Autowired(required=false)
    protected HttpServletRequest request;

    public String getText(Object code, Object ... args) {
        String codeString = String.valueOf(code);
        return this.messageSource.getMessage(codeString, args, codeString, this.request == null ? Locale.CHINA : this.request.getLocale());
    }

    public String getTextDefaultNull(Object code, Object ... args) {
        return this.messageSource.getMessage(String.valueOf(code), args, null, this.request == null ? Locale.CHINA : this.request.getLocale());
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public String getUserAgent() {
        return StringUtil.valueOf(this.request.getHeaders("user-agent"));
    }

    protected String getDeviceInfo() {
        String user_agent = this.getUserAgent();
        if (user_agent.indexOf("Android") > 0 || user_agent.indexOf("Commons-HttpClient") > 0) {
            return "Android";
        }
        if (user_agent.indexOf("iPhone") > 0) {
            return "iPhone";
        }
        return "WEB";
    }

    protected Pageable getDefaultPageable(Pageable pageable, Sort sort) {
        if (pageable.getSort() == null) {
            pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), sort);
        }
        return pageable;
    }

    protected Pageable getDefaultPageable(Pageable pageable, Class<?> modelType) {
        if (pageable == null) {
            return null;
        }
        if (pageable.getSort() == null) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            this.publisher.publishEvent((ApplicationEvent)new DefaultSortEvent(orders, modelType));
            if (orders.isEmpty()) {
                orders.add(new Sort.Order(Sort.Direction.DESC, "id"));
            }
            pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(orders));
        }
        return pageable;
    }

    protected void link(PersistentEntityResource resource, Link defaultSelfRel) {
        Object content = resource.getContent();
        this.publisher.publishEvent((ApplicationEvent)new SelfRelEvent(content, resource));
        if (resource.getLinks() == null) {
            resource.add(defaultSelfRel);
        }
        this.publisher.publishEvent((ApplicationEvent)new AddLinkEvent(content, resource));
    }
}

