/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.controller;

import cn.bestwu.framework.data.JpaSearchRepository;
import cn.bestwu.framework.data.SearchRepository;
import cn.bestwu.framework.rest.annotation.RepositoryRestController;
import cn.bestwu.framework.rest.controller.BaseController;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import cn.bestwu.framework.rest.support.PersistentEntityResource;
import cn.bestwu.framework.rest.support.RootResourceInformation;
import java.lang.reflect.Method;
import org.hibernate.search.annotations.Indexed;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RepositoryRestController
@RequestMapping(value={"/{repository}"})
public class RepositorySearchController
extends BaseController {
    @Autowired(required=false)
    private SearchRepository searchRepository;

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public Object search(RootResourceInformation resourceInformation, String keyword, Pageable pageable, boolean highLight) throws NoSuchMethodException {
        if (this.searchRepository == null) {
            throw new ResourceNotFoundException();
        }
        Assert.hasText((String)keyword, (String)this.getText("param.notnull", "keyword"));
        Class<?> modelType = resourceInformation.getModelType();
        if (JpaSearchRepository.class.equals((Object)AopProxyUtils.ultimateTargetClass((Object)this.searchRepository)) && !modelType.isAnnotationPresent(Indexed.class)) {
            throw new ResourceNotFoundException();
        }
        Page page = this.searchRepository.search(modelType, keyword, pageable, highLight);
        Link selfRel = ControllerLinkBuilder.linkTo(RepositorySearchController.class, (Method)RepositorySearchController.class.getMethod("search", RootResourceInformation.class, String.class, Pageable.class, Boolean.TYPE), (Object[])new Object[]{resourceInformation.getPathName()}).withSelfRel();
        return this.ok(new PersistentEntityResource<Page>(page, resourceInformation.getEntity(), selfRel));
    }
}

