/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.mapping;

import cn.bestwu.framework.rest.annotation.RepositoryRestController;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import cn.bestwu.framework.rest.mapping.RepositoryResourceMappings;
import cn.bestwu.framework.rest.support.ProxyPathMapper;
import cn.bestwu.framework.rest.support.RepositoryResourceMetadata;
import cn.bestwu.framework.rest.support.ResourceType;
import cn.bestwu.framework.rest.support.Version;
import cn.bestwu.framework.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class VersionRepositoryRestRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    public static final String REQUEST_HANDLER_METHOD = "request_handler_method";
    public static final String REQUEST_REPOSITORY_BASE_PATH_NAME = "request_repository_base_path_name";
    public static final String REQUEST_REPOSITORY_SEARCH_NAME = "request_repository_search_name";
    public static final String REQUEST_REPOSITORY_RESOURCE_METADATA = "request_repository_resource_metadata";
    public static final String COLLECTION_LOOKUP_PATH_REGEX = "^/[^/]+/?$";
    private final String[] IGNORED_LOOKUP_PATH = new String[]{"/oauth/authorize", "/oauth/token", "/oauth/check_token", "/oauth/confirm_access", "/oauth/error"};
    public final MediaType DEFAULT_MEDIA_TYPE = MediaType.parseMediaType((String)"*/*");
    private final ContentNegotiationManager contentNegotiationManager;
    private final RepositoryResourceMappings repositoryResourceMappings;
    private final ProxyPathMapper proxyPathMapper;
    public static final Comparator<MediaType> VERSION_COMPARATOR = new MimeType.SpecificityComparator<MediaType>(){

        public int compare(MediaType mimeType1, MediaType mimeType2) {
            int qualityComparison = this.compareVersion(mimeType1, mimeType2);
            if (qualityComparison != 0) {
                return qualityComparison;
            }
            return super.compare((MimeType)mimeType1, (MimeType)mimeType2);
        }

        private int compareVersion(MediaType mediaType1, MediaType mediaType2) {
            String version1 = mediaType1.getParameter("version");
            String version2 = mediaType2.getParameter("version");
            if (!StringUtils.hasText((String)version1)) {
                version1 = "1.0";
            }
            if (!StringUtils.hasText((String)version2)) {
                version2 = "1.0";
            }
            return Version.compareVersion(version1, version2);
        }
    };

    public VersionRepositoryRestRequestMappingHandlerMapping(ContentNegotiationManager contentNegotiationManager, RepositoryResourceMappings repositoryResourceMappings, ProxyPathMapper proxyPathMapper) {
        Assert.notNull((Object)contentNegotiationManager);
        Assert.notNull((Object)repositoryResourceMappings);
        this.contentNegotiationManager = contentNegotiationManager;
        this.repositoryResourceMappings = repositoryResourceMappings;
        this.proxyPathMapper = proxyPathMapper;
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        if (this.proxyPathMapper != null) {
            lookupPath = this.proxyPathMapper.getProxyPath(lookupPath);
        }
        if (ArrayUtil.contains(this.IGNORED_LOOKUP_PATH, lookupPath)) {
            return null;
        }
        HandlerMethod handlerMethod = super.lookupHandlerMethod(lookupPath, request);
        if (handlerMethod == null) {
            return null;
        }
        request.setAttribute(REQUEST_HANDLER_METHOD, (Object)handlerMethod);
        Class beanType = handlerMethod.getBeanType();
        if (!beanType.isAnnotationPresent(RepositoryRestController.class)) {
            return handlerMethod;
        }
        String basePathName = VersionRepositoryRestRequestMappingHandlerMapping.getBasePathName(lookupPath);
        if (!StringUtils.hasText((String)basePathName)) {
            return handlerMethod;
        }
        request.setAttribute(REQUEST_REPOSITORY_BASE_PATH_NAME, (Object)basePathName);
        RepositoryResourceMetadata repositoryResourceMetadata = this.repositoryResourceMappings.getRepositoryResourceMetadata(basePathName);
        request.setAttribute(REQUEST_REPOSITORY_RESOURCE_METADATA, (Object)repositoryResourceMetadata);
        if (repositoryResourceMetadata != null) {
            String SEARCH_LOOKUP_PATH_REGEX = "^/[^/]+/search(/[^/]+)?/?$";
            if (lookupPath.matches(SEARCH_LOOKUP_PATH_REGEX)) {
                return handlerMethod;
            }
            if (repositoryResourceMetadata.isExported()) {
                ResourceType resourceType = null;
                String ITEM_LOOKUP_PATH_REGEX = "^/[^/]+/[^/]+/?$";
                if (lookupPath.matches(ITEM_LOOKUP_PATH_REGEX)) {
                    resourceType = ResourceType.ITEM;
                } else if (lookupPath.matches(COLLECTION_LOOKUP_PATH_REGEX)) {
                    resourceType = ResourceType.COLLECTION;
                }
                repositoryResourceMetadata.verifySupportedMethod(request.getMethod(), resourceType);
                return handlerMethod;
            }
            throw new ResourceNotFoundException(lookupPath);
        }
        return null;
    }

    public static String getBasePathName(String lookupPath) {
        int secondSlashIndex = lookupPath.indexOf(47, lookupPath.startsWith("/") ? 1 : 0);
        boolean noSecondSlashIndex = secondSlashIndex == -1;
        return noSecondSlashIndex ? lookupPath.substring(1) : lookupPath.substring(1, secondSlashIndex);
    }

    protected Comparator<RequestMappingInfo> getMappingComparator(HttpServletRequest request) {
        return (info1, info2) -> this.compareTo((RequestMappingInfo)info1, (RequestMappingInfo)info2, request);
    }

    private int compareTo(RequestMappingInfo me, RequestMappingInfo other, HttpServletRequest request) {
        int result = me.getPatternsCondition().compareTo(other.getPatternsCondition(), request);
        if (result != 0) {
            return result;
        }
        result = me.getParamsCondition().compareTo(other.getParamsCondition(), request);
        if (result != 0) {
            return result;
        }
        result = me.getHeadersCondition().compareTo(other.getHeadersCondition(), request);
        if (result != 0) {
            return result;
        }
        result = me.getConsumesCondition().compareTo(other.getConsumesCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.versionsConditionCompareTo(me.getProducesCondition(), other.getProducesCondition(), request);
        if (result != 0) {
            return result;
        }
        result = me.getProducesCondition().compareTo(other.getProducesCondition(), request);
        if (result != 0) {
            return result;
        }
        result = me.getMethodsCondition().compareTo(other.getMethodsCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.customConditionCompareTo(me.getCustomCondition(), other.getCustomCondition(), request);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    private int versionsConditionCompareTo(ProducesRequestCondition me, ProducesRequestCondition other, HttpServletRequest request) {
        try {
            ArrayList<MediaType> otherProducibleMediaTypes;
            ArrayList<MediaType> meProducibleMediaTypes = new ArrayList<MediaType>(me.getProducibleMediaTypes());
            if (meProducibleMediaTypes.isEmpty()) {
                meProducibleMediaTypes.add(this.DEFAULT_MEDIA_TYPE);
            }
            if ((otherProducibleMediaTypes = new ArrayList<MediaType>(other.getProducibleMediaTypes())).isEmpty()) {
                otherProducibleMediaTypes.add(this.DEFAULT_MEDIA_TYPE);
            }
            meProducibleMediaTypes.sort(VERSION_COMPARATOR);
            otherProducibleMediaTypes.sort(VERSION_COMPARATOR);
            List<MediaType> acceptedMediaTypes = this.getAcceptedMediaTypes(request);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                int otherIndex;
                int thisIndex = this.equalVersion(meProducibleMediaTypes, acceptedMediaType);
                int result = this.compareMatchingMediaTypes(meProducibleMediaTypes, thisIndex, otherProducibleMediaTypes, otherIndex = this.equalVersion(otherProducibleMediaTypes, acceptedMediaType));
                if (result != 0) {
                    return result;
                }
                thisIndex = this.includedVersion(meProducibleMediaTypes, acceptedMediaType);
                result = this.compareMatchingMediaTypes(meProducibleMediaTypes, thisIndex, otherProducibleMediaTypes, otherIndex = this.includedVersion(otherProducibleMediaTypes, acceptedMediaType));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        catch (HttpMediaTypeNotAcceptableException ex) {
            throw new IllegalStateException("Cannot compare without having any requested media types", ex);
        }
    }

    private int compareMatchingMediaTypes(List<MediaType> mediaTypes1, int index1, List<MediaType> mediaTypes2, int index2) {
        int result = 0;
        if (index1 != index2) {
            result = index2 - index1;
        } else if (index1 != -1) {
            MediaType mediaType2;
            MediaType mediaType1 = mediaTypes1.get(index1);
            result = VERSION_COMPARATOR.compare(mediaType1, mediaType2 = mediaTypes2.get(index2));
            result = result != 0 ? result : mediaType1.compareTo((MimeType)mediaType2);
        }
        return result;
    }

    private int equalVersion(List<MediaType> mediaTypes, MediaType accepteMediaType) {
        for (int i = 0; i < mediaTypes.size(); ++i) {
            MediaType currentMediaType = mediaTypes.get(i);
            if (!this.equals(accepteMediaType, currentMediaType)) continue;
            return i;
        }
        return -1;
    }

    private int includedVersion(List<MediaType> mediaTypes, MediaType mediaType) {
        for (int i = 0; i < mediaTypes.size(); ++i) {
            MediaType currentMediaType = mediaTypes.get(i);
            if (!this.included(mediaType, currentMediaType)) continue;
            return i;
        }
        return -1;
    }

    private boolean equals(MediaType accepteMediaType, MediaType currentMediaType) {
        String currentVersion = currentMediaType.getParameter("version");
        String acceptedVersion = accepteMediaType.getParameter("version");
        if (!StringUtils.hasText((String)currentVersion)) {
            currentVersion = "1.0";
        }
        if (!StringUtils.hasText((String)acceptedVersion)) {
            return true;
        }
        return acceptedVersion.equalsIgnoreCase(currentVersion);
    }

    private boolean included(MediaType accepteMediaType, MediaType currentMediaType) {
        String acceptedVersion = accepteMediaType.getParameter("version");
        String currentVersion = currentMediaType.getParameter("version");
        if (!StringUtils.hasText((String)currentVersion)) {
            currentVersion = "1.0";
        }
        if (!StringUtils.hasText((String)acceptedVersion)) {
            return true;
        }
        return currentVersion.contains(acceptedVersion) || currentVersion.matches(acceptedVersion);
    }

    private List<MediaType> getAcceptedMediaTypes(HttpServletRequest request) throws HttpMediaTypeNotAcceptableException {
        List<MediaType> mediaTypes = this.contentNegotiationManager.resolveMediaTypes((NativeWebRequest)new ServletWebRequest(request));
        return mediaTypes.isEmpty() ? Collections.singletonList(MediaType.ALL) : mediaTypes;
    }

    private int customConditionCompareTo(RequestCondition me, RequestCondition other, HttpServletRequest request) {
        Class<?> otherClazz;
        if (me == null && other == null) {
            return 0;
        }
        if (me == null) {
            return 1;
        }
        if (other == null) {
            return -1;
        }
        Class<?> clazz = me.getClass();
        if (!clazz.equals(otherClazz = other.getClass())) {
            throw new ClassCastException("Incompatible request conditions: " + clazz + " and " + otherClazz);
        }
        return me.compareTo((Object)other, request);
    }
}

