/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.resolver;

import cn.bestwu.framework.event.AddPredicateEvent;
import cn.bestwu.framework.event.DefaultPredicateEvent;
import cn.bestwu.framework.rest.support.ParameterUtil;
import cn.bestwu.framework.rest.support.Resource;
import com.mysema.query.types.Predicate;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.MethodParameter;
import org.springframework.data.querydsl.binding.FixQuerydslPredicateBuilder;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class QuerydslPredicateArgumentResolver
implements HandlerMethodArgumentResolver {
    private final QuerydslBindingsFactory bindingsFactory;
    private final FixQuerydslPredicateBuilder predicateBuilder;
    private final ApplicationEventPublisher publisher;

    public QuerydslPredicateArgumentResolver(QuerydslBindingsFactory bindingsFactory, FixQuerydslPredicateBuilder predicateBuilder, ApplicationEventPublisher publisher) {
        this.bindingsFactory = bindingsFactory;
        this.predicateBuilder = predicateBuilder;
        this.publisher = publisher;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (Predicate.class.equals((Object)parameter.getParameterType())) {
            return true;
        }
        if (parameter.hasParameterAnnotation(QuerydslPredicate.class)) {
            throw new IllegalArgumentException(String.format("Parameter at position %s must be of type Predicate but was %s.", parameter.getParameterIndex(), parameter.getParameterType()));
        }
        return false;
    }

    public Predicate resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        for (Map.Entry entry : webRequest.getParameterMap().entrySet()) {
            parameters.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        QuerydslPredicate annotation = (QuerydslPredicate)parameter.getParameterAnnotation(QuerydslPredicate.class);
        TypeInformation typeInformation = QuerydslPredicateArgumentResolver.extractTypeInfo(parameter).getActualType();
        Class customizer = annotation == null ? null : annotation.bindings();
        QuerydslBindings bindings = this.bindingsFactory.createBindingsFor(customizer, typeInformation);
        Class modelType = typeInformation.getType();
        ParameterUtil.setPredicateDefaultActiveParameter((MultiValueMap<String, String>)parameters);
        this.publisher.publishEvent((ApplicationEvent)new DefaultPredicateEvent((MultiValueMap<String, String>)parameters, modelType));
        Predicate predicate = this.predicateBuilder.getPredicate(typeInformation, (MultiValueMap<String, String>)parameters, bindings);
        Resource<Predicate> predicateResource = new Resource<Predicate>(predicate);
        this.publisher.publishEvent((ApplicationEvent)new AddPredicateEvent(predicateResource, modelType));
        predicate = predicateResource.getContent();
        return predicate;
    }

    static TypeInformation<?> extractTypeInfo(MethodParameter parameter) {
        QuerydslPredicate annotation = (QuerydslPredicate)parameter.getParameterAnnotation(QuerydslPredicate.class);
        if (annotation != null && !Object.class.equals((Object)annotation.root())) {
            return ClassTypeInformation.from((Class)annotation.root());
        }
        return QuerydslPredicateArgumentResolver.detectModelType(ClassTypeInformation.fromReturnTypeOf((Method)parameter.getMethod()));
    }

    private static TypeInformation<?> detectModelType(TypeInformation<?> source) {
        if (source.getTypeArguments().isEmpty()) {
            return source;
        }
        TypeInformation actualType = source.getActualType();
        if (source != actualType) {
            return QuerydslPredicateArgumentResolver.detectModelType(actualType);
        }
        if (source instanceof Iterable) {
            return source;
        }
        return QuerydslPredicateArgumentResolver.detectModelType(source.getComponentType());
    }
}

