/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import cn.bestwu.framework.rest.controller.BaseController;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Order(value=-2147483648)
public class BaseErrorAttributes
extends BaseController
implements ErrorAttributes,
HandlerExceptionResolver,
Ordered {
    private final String ERROR_ATTRIBUTE = BaseErrorAttributes.class.getName() + ".ERROR";
    protected final String KEY_STATUS = "status";
    protected final String KEY_MESSAGE = "message";
    protected final String KEY_HTTP_STATUS_CODE = "httpStatusCode";

    public Map<String, Object> getErrorAttributes(RequestAttributes requestAttributes, boolean includeStackTrace) {
        String message;
        String statusCode = null;
        Integer httpStatusCode = null;
        HashMap<String, String> errors = new HashMap<String, String>();
        Throwable e = this.getError(requestAttributes);
        if (this.logger.isDebugEnabled() && e != null) {
            this.logger.debug(e.getMessage(), e);
        }
        LinkedHashMap<String, Object> errorAttributes = new LinkedHashMap<String, Object>();
        if (e != null) {
            message = e.getMessage();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(message);
            }
            if (includeStackTrace) {
                this.addStackTrace(errorAttributes, e);
            }
            if (e instanceof ResourceNotFoundException || e instanceof EmptyResultDataAccessException) {
                httpStatusCode = HttpStatus.NOT_FOUND.value();
                if (!StringUtils.hasText((String)message)) {
                    message = "Resource not found!";
                }
            } else if (e instanceof HttpRequestMethodNotSupportedException) {
                httpStatusCode = HttpStatus.METHOD_NOT_ALLOWED.value();
                if (!StringUtils.hasText((String)message)) {
                    message = "Method not allowed!";
                }
            } else if (e instanceof BindException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                BindException er = (BindException)e;
                List fieldErrors = er.getFieldErrors();
                fieldErrors.forEach(fieldError -> {
                    String defaultMessage = fieldError.getDefaultMessage();
                    if (defaultMessage.contains("required type")) {
                        defaultMessage = this.getText(fieldError.getCode(), new Object[0]);
                    }
                    errors.put(fieldError.getField(), this.getText(fieldError.getField(), new Object[0]) + defaultMessage);
                });
                message = (String)errors.values().iterator().next();
                if (!StringUtils.hasText((String)message)) {
                    message = this.getText("data.valid.failed", new Object[0]);
                }
            } else if (e instanceof IllegalArgumentException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                if (!StringUtils.hasText((String)message)) {
                    message = this.getText("data.valid.failed", new Object[0]);
                }
            } else if (e instanceof ConversionFailedException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                message = this.getText("typeMismatch", ((ConversionFailedException)e).getValue(), ((ConversionFailedException)e).getTargetType());
                if (!StringUtils.hasText((String)message)) {
                    message = this.getText("data.valid.failed", new Object[0]);
                }
            } else if (e instanceof ConstraintViolationException || e instanceof TransactionSystemException) {
                if (e instanceof TransactionSystemException) {
                    e = ((TransactionSystemException)e).getRootCause();
                }
                if (e instanceof ConstraintViolationException) {
                    httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                    ConstraintViolationException er = (ConstraintViolationException)e;
                    Set constraintViolations = er.getConstraintViolations();
                    constraintViolations.forEach(constraintViolation -> errors.put(constraintViolation.getPropertyPath().toString(), this.getText(constraintViolation.getPropertyPath(), new Object[0]) + constraintViolation.getMessage()));
                    message = (String)errors.values().iterator().next();
                    if (!StringUtils.hasText((String)message)) {
                        message = this.getText("data.valid.failed", new Object[0]);
                    }
                } else {
                    this.logger.error(message, e);
                }
            } else if (e instanceof DataIntegrityViolationException) {
                String specificCauseMessage = ((DataIntegrityViolationException)e).getMostSpecificCause().getMessage();
                String duplicateRegex = "^Duplicate entry '(.*?)'.*";
                String constraintSubfix = "Cannot delete or update a parent row";
                if (specificCauseMessage.matches(duplicateRegex)) {
                    httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                    message = this.getText("duplicate.entry", specificCauseMessage.replaceAll(duplicateRegex, "$1"));
                    if (!StringUtils.hasText((String)message)) {
                        message = this.getText("data.valid.failed", new Object[0]);
                    }
                } else if (specificCauseMessage.startsWith(constraintSubfix)) {
                    httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                    message = this.getText("cannot.delete.update.parent", new Object[0]);
                    if (!StringUtils.hasText((String)message)) {
                        message = this.getText("data.valid.failed", new Object[0]);
                    }
                } else {
                    message = ((DataIntegrityViolationException)e).getRootCause().getMessage();
                }
            } else if (e instanceof HttpMediaTypeNotAcceptableException) {
                httpStatusCode = HttpStatus.NOT_ACCEPTABLE.value();
                message = "MediaType not Acceptable!Must ACCEPT:" + ((HttpMediaTypeNotAcceptableException)e).getSupportedMediaTypes();
            } else if (e instanceof IllegalStateException) {
                httpStatusCode = HttpStatus.BAD_REQUEST.value();
            } else if (e instanceof PropertyReferenceException) {
                httpStatusCode = HttpStatus.BAD_REQUEST.value();
            } else {
                this.handlerException(e, errorAttributes, errors);
                statusCode = (String)errorAttributes.get("status");
                httpStatusCode = (Integer)errorAttributes.get("httpStatusCode");
                errorAttributes.remove("httpStatusCode");
                Object handedMessage = errorAttributes.get("message");
                message = handedMessage == null ? message : (String)handedMessage;
            }
        } else {
            message = (String)this.getAttribute(requestAttributes, "javax.servlet.error.message");
        }
        String string = message = StringUtils.isEmpty((Object)message) ? "No message available" : message;
        if (httpStatusCode == null && (httpStatusCode = Integer.valueOf(this.getStatus(requestAttributes).value())) != 403 && httpStatusCode != 401 && httpStatusCode != 404) {
            this.logger.error(httpStatusCode + ":" + message, e);
        }
        statusCode = statusCode == null ? String.valueOf(httpStatusCode) : statusCode;
        this.setStatus(requestAttributes, httpStatusCode);
        errorAttributes.put("status", statusCode);
        errorAttributes.put("message", message);
        if (!errors.isEmpty()) {
            errorAttributes.put("errors", errors);
        }
        return errorAttributes;
    }

    protected void handlerException(Throwable error, Map<String, Object> errorAttributes, Map<String, String> errors) {
    }

    private void addStackTrace(Map<String, Object> errorAttributes, Throwable error) {
        StringWriter stackTrace = new StringWriter();
        error.printStackTrace(new PrintWriter(stackTrace));
        stackTrace.flush();
        errorAttributes.put("trace", stackTrace.toString());
    }

    public Throwable getError(RequestAttributes requestAttributes) {
        Throwable exception = (Throwable)this.getAttribute(requestAttributes, this.ERROR_ATTRIBUTE);
        if (exception == null) {
            exception = (Throwable)this.getAttribute(requestAttributes, "javax.servlet.error.exception");
        }
        return exception;
    }

    private void setStatus(RequestAttributes requestAttributes, Object statusCode) {
        requestAttributes.setAttribute("javax.servlet.error.status_code", statusCode, 0);
    }

    private HttpStatus getStatus(RequestAttributes requestAttributes) {
        Integer statusCode = (Integer)this.getAttribute(requestAttributes, "javax.servlet.error.status_code");
        if (statusCode != null) {
            try {
                return HttpStatus.valueOf((int)statusCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    private <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        return (T)requestAttributes.getAttribute(name, 0);
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        request.setAttribute(this.ERROR_ATTRIBUTE, (Object)ex);
        return null;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

