/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import cn.bestwu.framework.data.annotation.EnableAllDataInOnePage;
import cn.bestwu.framework.data.annotation.RepositoryRestResource;
import cn.bestwu.framework.data.annotation.SearchResource;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import cn.bestwu.framework.rest.support.ResourceType;
import cn.bestwu.framework.rest.support.ResourceUtil;
import cn.bestwu.framework.util.ArrayUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;

public class RepositoryResourceMetadata {
    private boolean exported;
    private String pathName;
    private PersistentEntity<?, ?> entity;
    private Map<ResourceType, Set<String>> supportedHttpMethods;
    private Map<String, Method> searchMethods;
    private boolean enableAllDataInOnePage;
    private boolean contained = false;

    public RepositoryResourceMetadata(PersistentEntity<?, ?> entity, Class<?> repositoryInterface, CrudMethods crudMethods) {
        this.entity = entity;
        this.enableAllDataInOnePage = repositoryInterface.isAnnotationPresent(EnableAllDataInOnePage.class);
        Method[] methods = repositoryInterface.getMethods();
        Arrays.stream(methods).forEach(method -> {
            SearchResource searchResource = method.getAnnotation(SearchResource.class);
            if (searchResource != null) {
                String searchResourceName = searchResource.value();
                if (!StringUtils.hasText((String)searchResourceName)) {
                    searchResourceName = StringUtils.uncapitalize((String)method.getName().replace("find", "").replace("findBy", "").replace("query", "").replace("queryBy", ""));
                }
                if (this.searchMethods == null) {
                    this.searchMethods = new HashMap<String, Method>();
                }
                this.searchMethods.put(searchResourceName, (Method)method);
            }
        });
        RepositoryRestResource annotation = repositoryInterface.getAnnotation(RepositoryRestResource.class);
        if (annotation != null) {
            this.exported = annotation.exported();
            this.pathName = annotation.pathName();
            this.contained = annotation.contained();
            if ("".equals(this.pathName)) {
                this.pathName = ResourceUtil.getRepositoryBasePathName(entity.getType());
            }
        } else {
            this.exported = false;
            this.pathName = ResourceUtil.getRepositoryBasePathName(entity.getType());
        }
        if (this.exported) {
            HashMap supportedHttpMethods = new HashMap();
            Method findAllMethod = crudMethods.getFindAllMethod();
            Method findOneMethod = crudMethods.getFindOneMethod();
            Method saveMethod = crudMethods.getSaveMethod();
            Method deleteMethod = crudMethods.getDeleteMethod();
            HashSet<String> collectionMethods = new HashSet<String>();
            if (this.exposesMethod(findAllMethod, "GET")) {
                collectionMethods.add("GET");
            }
            if (this.exposesMethod(saveMethod, "POST")) {
                collectionMethods.add("POST");
            }
            if (this.exposesMethod(deleteMethod, "DELETE")) {
                collectionMethods.add("DELETE");
            }
            supportedHttpMethods.put(ResourceType.COLLECTION, Collections.unmodifiableSet(collectionMethods));
            HashSet<String> itemMethods = new HashSet<String>();
            if (this.exposesMethod(findOneMethod, "GET")) {
                itemMethods.add("GET");
            }
            if (this.exposesMethod(saveMethod, "PUT")) {
                itemMethods.add("PUT");
            }
            if (this.exposesMethod(deleteMethod, "DELETE")) {
                itemMethods.add("DELETE");
            }
            supportedHttpMethods.put(ResourceType.ITEM, Collections.unmodifiableSet(itemMethods));
            this.supportedHttpMethods = Collections.unmodifiableMap(supportedHttpMethods);
        }
    }

    private boolean exposesMethod(Method method, String httpMethod) {
        if (method == null) {
            return false;
        }
        RepositoryRestResource annotation = method.getAnnotation(RepositoryRestResource.class);
        if (annotation == null) {
            return !this.contained;
        }
        if (!annotation.exported()) {
            return false;
        }
        Object[] array = annotation.value();
        if (array.length == 0) {
            return true;
        }
        return ArrayUtil.contains(array, httpMethod);
    }

    public PersistentEntity<?, ?> getEntity() {
        return this.entity;
    }

    public boolean isExported() {
        return this.exported;
    }

    public String getPathName() {
        return this.pathName;
    }

    public Class<?> getModelType() {
        return this.entity.getType();
    }

    public void verifySupportedMethod(String requestHttpMethod, ResourceType resourceType) throws HttpRequestMethodNotSupportedException {
        if (resourceType == null) {
            throw new ResourceNotFoundException();
        }
        Set<String> supportedHttpMethods = this.supportedHttpMethods.get((Object)resourceType);
        if (supportedHttpMethods == null || supportedHttpMethods.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        if (!supportedHttpMethods.contains(requestHttpMethod)) {
            throw new HttpRequestMethodNotSupportedException(requestHttpMethod, supportedHttpMethods);
        }
    }

    public boolean enableAllDataInOnePage() {
        return this.enableAllDataInOnePage;
    }

    public Method getSearchMethod(String search) {
        if (CollectionUtils.isEmpty(this.searchMethods)) {
            return null;
        }
        return this.searchMethods.get(search);
    }
}

