/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import cn.bestwu.framework.util.StringUtil;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.atteo.evo.inflector.English;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

public class ResourceUtil {
    public static final String SEPARATOR = ",";
    private static AnnotationMappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(RequestMapping.class);

    public static String getRepositoryBasePathName(Class<?> clazz) {
        return English.plural((String)StringUtils.uncapitalize((String)clazz.getSimpleName()));
    }

    public static String getRequestSignature(HttpServletRequest request) {
        String searchName;
        HandlerMethod handlerMethod = (HandlerMethod)request.getAttribute("request_handler_method");
        if (handlerMethod == null) {
            return null;
        }
        String apiSignature = request.getMethod() + DISCOVERER.getMapping(handlerMethod.getMethod());
        String repositoryBasePathName = (String)request.getAttribute("request_repository_base_path_name");
        if (repositoryBasePathName != null) {
            apiSignature = apiSignature.replace("{repository}", repositoryBasePathName);
        }
        if ((searchName = (String)request.getAttribute("request_repository_search_name")) != null) {
            apiSignature = apiSignature.replace("{search}", searchName);
        }
        apiSignature = StringUtil.addUnderscores(apiSignature.replaceAll("[{}]", "").replace("/", "_")).toUpperCase();
        return apiSignature;
    }

    public static String getRequestVersion(HttpServletRequest request) {
        String request_version_key = "REQUEST_VERSION";
        String version = (String)request.getAttribute(request_version_key);
        if (version == null) {
            Enumeration accept = request.getHeaders("Accept");
            while (accept.hasMoreElements()) {
                String s;
                String[] split;
                String element = (String)accept.nextElement();
                String[] stringArray = split = element.split(SEPARATOR);
                int n = stringArray.length;
                for (int i = 0; i < n && !StringUtils.hasText((String)(version = ResourceUtil.getVersion(s = stringArray[i]))); ++i) {
                }
            }
            if (!StringUtils.hasText((String)version)) {
                version = "1.0";
            }
            request.setAttribute(request_version_key, (Object)version);
        }
        return version;
    }

    public static String getVersion(String versionAcceptParam) {
        return MediaType.valueOf((String)versionAcceptParam).getParameter("version");
    }
}

