/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import cn.bestwu.framework.event.SelfRelEvent;
import cn.bestwu.framework.rest.controller.RepositoryEntityController;
import cn.bestwu.framework.rest.support.ETag;
import cn.bestwu.framework.rest.support.PersistentEntityResource;
import cn.bestwu.framework.rest.support.ResourceUtil;
import cn.bestwu.framework.util.Sha1DigestUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.support.Repositories;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;

public class Response {
    @Value(value="${server.client-cache:true}")
    private boolean supportClientCache;
    @Autowired
    private AuditableBeanWrapperFactory auditableBeanWrapperFactory;
    @Autowired
    private Repositories repositories;
    @Autowired
    protected ApplicationEventPublisher publisher;

    protected PersistentEntity<?, ?> getPersistentEntity(Class<?> modelType) {
        return this.repositories.getPersistentEntity(modelType);
    }

    private HttpHeaders prepareHeaders(PersistentEntity<?, ?> entity, Object value) {
        HttpHeaders headers = ETag.from(entity, value).addTo(new HttpHeaders());
        AuditableBeanWrapper wrapper = this.getAuditableBeanWrapper(value);
        if (wrapper == null) {
            return headers;
        }
        Calendar lastModifiedDate = wrapper.getLastModifiedDate();
        if (lastModifiedDate != null) {
            headers.setLastModified(lastModifiedDate.getTimeInMillis());
        }
        return headers;
    }

    private static HttpHeaders noCache() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "-1");
        return headers;
    }

    private AuditableBeanWrapper getAuditableBeanWrapper(Object source) {
        return this.auditableBeanWrapperFactory.getBeanWrapperFor(source);
    }

    protected ResponseEntity created(PersistentEntityResource<?> entityResource) {
        if (this.supportClientCache) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)URI.create(entityResource.getLinks().get("self"))).headers(this.prepareHeaders(entityResource.getEntity(), entityResource.getContent()))).body(entityResource);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)URI.create(entityResource.getLinks().get("self"))).headers(Response.noCache())).body(entityResource);
    }

    protected ResponseEntity updated(PersistentEntityResource<?> entityResource) {
        if (this.supportClientCache) {
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().location(URI.create(entityResource.getLinks().get("self")))).headers(this.prepareHeaders(entityResource.getEntity(), entityResource.getContent()))).body(entityResource);
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().location(URI.create(entityResource.getLinks().get("self")))).headers(Response.noCache())).body(entityResource);
    }

    protected ResponseEntity ok(Object object) {
        if (this.supportClientCache) {
            return ResponseEntity.ok((Object)object);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(Response.noCache())).body(object);
    }

    protected ResponseEntity ok(PersistentEntityResource<?> resource) {
        Object source = resource.getContent();
        Assert.notNull(source);
        if (source instanceof Page) {
            Page page = (Page)source;
            List content = page.getContent();
            if (!content.isEmpty()) {
                ResourceConverter converter = this.getResourceConverter(resource);
                page = page.map((Converter)converter);
                ResponseEntity.BodyBuilder bodyBuilder = converter.getBodyBuilder();
                return bodyBuilder.body(resource.map(page));
            }
        } else if (source instanceof Iterable) {
            Iterable iterable = (Iterable)source;
            if (iterable.iterator().hasNext()) {
                ResourceConverter converter = this.getResourceConverter(resource);
                ArrayList newContent = new ArrayList();
                iterable.forEach(object -> newContent.add(converter.convert(object)));
                ResponseEntity.BodyBuilder bodyBuilder = converter.getBodyBuilder();
                return bodyBuilder.body(resource.map(newContent));
            }
        } else {
            if (this.supportClientCache) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.prepareHeaders(resource.getEntity(), resource.getContent()))).body(resource);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(Response.noCache())).body(resource);
        }
        if (this.supportClientCache) {
            return ResponseEntity.ok(resource);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(Response.noCache())).body(resource);
    }

    private ResourceConverter getResourceConverter(PersistentEntityResource<?> resource) {
        PersistentEntity<?, ?> entity = resource.getEntity();
        String repositoryBasePathName = ResourceUtil.getRepositoryBasePathName(entity.getType());
        ControllerLinkBuilder baseLinkBuilder = this.getBaseLinkBuilder(repositoryBasePathName);
        return new ResourceConverter(entity, baseLinkBuilder);
    }

    protected ControllerLinkBuilder getBaseLinkBuilder(String resourceName) {
        return ControllerLinkBuilder.linkTo(RepositoryEntityController.class, (Object[])new Object[]{resourceName});
    }

    protected Object getId(PersistentEntity<?, ?> persistentEntity, Object entity) {
        return persistentEntity.getIdentifierAccessor(entity).getIdentifier();
    }

    protected Object getId(Object entity) {
        return this.getPersistentEntity(entity.getClass()).getIdentifierAccessor(entity).getIdentifier();
    }

    protected ResponseEntity noContent() {
        return ResponseEntity.noContent().build();
    }

    public class ResourceConverter
    implements Converter<Object, PersistentEntityResource<?>> {
        private List<String> eTagValues = new ArrayList<String>();
        private List<Long> LastModifieds = new ArrayList<Long>();
        private boolean hasEtag = true;
        private boolean hasLastModified = true;
        private PersistentEntity<?, ?> persistentEntity = null;
        private ControllerLinkBuilder baseLinkBuilder = null;

        public ResourceConverter(PersistentEntity<?, ?> persistentEntity, ControllerLinkBuilder baseLinkBuilder) {
            this.persistentEntity = persistentEntity;
            this.baseLinkBuilder = baseLinkBuilder;
        }

        public PersistentEntityResource<?> convert(Object source) {
            if (Response.this.supportClientCache) {
                if (this.hasEtag) {
                    String eTagValue = ETag.getETagValue(this.persistentEntity, source);
                    if (eTagValue == null) {
                        this.hasEtag = false;
                    } else {
                        this.eTagValues.add(eTagValue);
                    }
                }
                if (this.hasLastModified) {
                    AuditableBeanWrapper wrapper = Response.this.getAuditableBeanWrapper(source);
                    if (wrapper == null) {
                        this.hasLastModified = false;
                    } else {
                        Calendar lastModifiedDate = wrapper.getLastModifiedDate();
                        if (lastModifiedDate == null) {
                            this.hasLastModified = false;
                        } else {
                            this.LastModifieds.add(lastModifiedDate.getTimeInMillis());
                        }
                    }
                }
            }
            PersistentEntityResource<Object> resource = new PersistentEntityResource<Object>(source, this.persistentEntity, new Link[0]);
            Response.this.publisher.publishEvent((ApplicationEvent)new SelfRelEvent(source, resource));
            if (resource.getLinks() == null) {
                Link link = ((ControllerLinkBuilder)this.baseLinkBuilder.slash(Response.this.getId(this.persistentEntity, source))).withSelfRel();
                resource.add(link);
            }
            return resource;
        }

        public ResponseEntity.BodyBuilder getBodyBuilder() {
            if (Response.this.supportClientCache) {
                HttpHeaders httpHeaders = new HttpHeaders();
                if (this.hasEtag) {
                    String eTagValue = "";
                    int size = this.eTagValues.size();
                    for (int i = 0; i < size; ++i) {
                        eTagValue = eTagValue.concat(this.eTagValues.get(i));
                        if (i == size - 1) continue;
                        eTagValue = eTagValue.concat("|");
                    }
                    eTagValue = "\"".concat(Sha1DigestUtil.shaHex(eTagValue)).concat("\"");
                    httpHeaders.setETag(eTagValue);
                }
                if (this.hasLastModified) {
                    Collections.sort(this.LastModifieds, (x, y) -> x < y ? 1 : (Objects.equals(x, y) ? 0 : -1));
                    httpHeaders.setLastModified(this.LastModifieds.get(0).longValue());
                }
                return (ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(httpHeaders);
            }
            return (ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(Response.noCache());
        }
    }
}

