/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.test.util;

import cn.bestwu.framework.test.util.PushbackBodyClientHttpResponseWrapper;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.TestRestTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriTemplate;

public class VersionSupportRestTemplate
extends TestRestTemplate {
    protected final Logger logger = LoggerFactory.getLogger(VersionSupportRestTemplate.class);
    private boolean print;

    public void setPrint(boolean print) {
        this.print = print;
    }

    public VersionSupportRestTemplate(TestRestTemplate.HttpClientOption ... httpClientOptions) {
        super(httpClientOptions);
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setOutputStreaming(false);
        this.setRequestFactory((ClientHttpRequestFactory)requestFactory);
    }

    public VersionSupportRestTemplate(String username, String password, TestRestTemplate.HttpClientOption ... httpClientOptions) {
        super(username, password, httpClientOptions);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, MediaType mediaType, Object ... urlVariables) throws RestClientException {
        URI expanded = new UriTemplate(url).expand(urlVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor, mediaType);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, MediaType mediaType, Map<String, ?> urlVariables) throws RestClientException {
        URI expanded = new UriTemplate(url).expand(urlVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor, mediaType);
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return this.doExecute(url, method, requestCallback, responseExtractor, null);
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, MediaType mediaType) throws RestClientException {
        Assert.notNull((Object)url, (String)"'url' must not be null");
        Assert.notNull((Object)method, (String)"'method' must not be null");
        try (ClientHttpResponse response = null;){
            ClientHttpRequest request = this.createRequest(url, method);
            if (requestCallback != null) {
                requestCallback.doWithRequest(request);
            }
            HttpHeaders requestHeaders = request.getHeaders();
            if (mediaType != null) {
                requestHeaders.setAccept(Collections.singletonList(mediaType));
            }
            response = request.execute();
            if (this.print && this.logger.isDebugEnabled()) {
                this.logger.debug("------------------------------");
                this.logger.debug("requestHeaders:");
                requestHeaders.forEach((s, strings) -> this.logger.debug(s + " : " + strings));
                this.logger.debug("------------------------------");
            }
            HttpHeaders responseHeaders = response.getHeaders();
            if (this.print && this.logger.isDebugEnabled()) {
                this.logger.debug("------------------------------");
                this.logger.debug("responseHeaders:");
                responseHeaders.forEach((s, strings) -> this.logger.debug(s + " : " + strings));
                this.logger.debug("------------------------------");
            }
            this.handleResponse(url, method, response);
            if (responseExtractor != null) {
                if (this.print && this.logger.isDebugEnabled()) {
                    this.logger.debug("------------------------------");
                    response = new PushbackBodyClientHttpResponseWrapper(response);
                    this.logger.debug("responseBody: \n" + ((PushbackBodyClientHttpResponseWrapper)response).readBody());
                    this.logger.debug("------------------------------");
                }
                Object object = responseExtractor.extractData(response);
                return (T)object;
            }
            T t = null;
            return t;
        }
    }

    public <T> T getForObject(String url, Class<T> responseType, MediaType mediaType, Object ... urlVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.GET, requestCallback, (ResponseExtractor<T>)responseExtractor, mediaType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, MediaType mediaType, Map<String, ?> urlVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, mediaType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, MediaType mediaType, Object ... urlVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, mediaType, urlVariables);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, MediaType mediaType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.POST, requestCallback, (ResponseExtractor<T>)responseExtractor, mediaType, uriVariables);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, MediaType mediaType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, mediaType, uriVariables);
    }

    public <T> T putForObject(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.PUT, requestCallback, (ResponseExtractor<T>)responseExtractor, null, null, uriVariables);
    }

    public <T> T putForObject(String url, Object request, Class<T> responseType, MediaType mediaType, Object ... uriVariables) {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.PUT, requestCallback, (ResponseExtractor<T>)responseExtractor, mediaType, uriVariables);
    }

    public <T> ResponseEntity<T> putForEntity(String url, Object request, Class<T> responseType, MediaType mediaType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.PUT, requestCallback, responseExtractor, mediaType, uriVariables);
    }

    public <T> ResponseEntity<T> putForEntity(String url, Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.PUT, requestCallback, responseExtractor, null, uriVariables);
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, MediaType mediaType, Object ... uriVariables) throws RestClientException {
        ResponseExtractor responseExtractor = this.responseEntityExtractor(null);
        return (ResponseEntity)this.execute(url, HttpMethod.DELETE, null, responseExtractor, mediaType, uriVariables);
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, MediaType mediaType, Map<String, ?> urlVariables) throws RestClientException {
        ResponseExtractor responseExtractor = this.responseEntityExtractor(null);
        return (ResponseEntity)this.execute(url, HttpMethod.DELETE, null, responseExtractor, mediaType, urlVariables);
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, Object ... uriVariables) throws RestClientException {
        ResponseExtractor responseExtractor = this.responseEntityExtractor(null);
        return (ResponseEntity)this.execute(url, HttpMethod.DELETE, null, responseExtractor, null, uriVariables);
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, Map<String, ?> urlVariables) throws RestClientException {
        ResponseExtractor responseExtractor = this.responseEntityExtractor(null);
        return (ResponseEntity)this.execute(url, HttpMethod.DELETE, null, responseExtractor, null, urlVariables);
    }
}

