/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework;

import cn.bestwu.framework.data.query.MongodbSearchRepository;
import cn.bestwu.framework.data.query.SearchRepository;
import cn.bestwu.framework.data.query.jpa.JpaSearchRepository;
import cn.bestwu.framework.event.AnnotatedEventHandlerInvoker;
import cn.bestwu.framework.rest.config.RestMvcConfiguration;
import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.search.jpa.Search;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.auditing.MappingAuditableBeanWrapperFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.repository.support.Repositories;

@Configuration
@AutoConfigureOrder(value=-2147483639)
@Import(value={RestMvcConfiguration.class})
public class DataRestConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={Repositories.class})
    public Repositories repositories() {
        return new Repositories((ListableBeanFactory)this.applicationContext);
    }

    @Bean
    public PersistentEntities persistentEntities() {
        ArrayList arrayList = new ArrayList();
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MappingContext.class).values().forEach(arrayList::add);
        return new PersistentEntities(arrayList);
    }

    @Bean
    public AuditableBeanWrapperFactory auditableBeanWrapperFactory() {
        return new MappingAuditableBeanWrapperFactory(this.persistentEntities());
    }

    @Bean
    public AnnotatedEventHandlerInvoker annotatedEventHandlerInvoker() {
        return new AnnotatedEventHandlerInvoker();
    }

    @Configuration
    @ConditionalOnMissingBean(value={SearchRepository.class})
    @ConditionalOnClass(value={TextCriteria.class})
    protected static class MongodbSearchRepositoryConfiguration {
        @Autowired
        private Repositories repositories;

        protected MongodbSearchRepositoryConfiguration() {
        }

        @Bean
        public SearchRepository searchRepository() {
            return new MongodbSearchRepository(this.repositories);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SearchRepository.class})
    @ConditionalOnClass(value={Search.class})
    protected static class JpaSearchRepositoryConfiguration {
        @PersistenceContext
        private EntityManager entityManager;
        @Autowired
        private ApplicationEventPublisher publisher;

        protected JpaSearchRepositoryConfiguration() {
        }

        @Bean
        public SearchRepository searchRepository() {
            return new JpaSearchRepository(this.entityManager, this.publisher);
        }
    }
}

