/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.data.query.jpa;

import cn.bestwu.framework.data.query.ResultHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

public class HighlightResultHandler
implements ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(HighlightResultHandler.class);
    private Query query;
    private Analyzer analyzer;
    private Class<?> modelType;
    private String[] highLightFields;
    private String preTag = "<font color=\"#ff0000\">";
    private String postTag = "</font>";

    public HighlightResultHandler() {
    }

    public HighlightResultHandler(String preTag, String postTag) {
        this.preTag = preTag;
        this.postTag = postTag;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setModelType(Class<?> modelType) {
        this.modelType = modelType;
    }

    public void setHighLightFields(String[] highLightFields) {
        this.highLightFields = highLightFields;
    }

    @Override
    public void accept(List result) {
        QueryScorer queryScorer = new QueryScorer(this.query);
        Highlighter highlighter = new Highlighter((Formatter)new SimpleHTMLFormatter(this.preTag, this.postTag), (Scorer)queryScorer);
        for (Object t : result) {
            for (String fieldName : this.highLightFields) {
                try {
                    if (fieldName.contains(".")) {
                        this.hightLightField(this.analyzer, this.modelType, highlighter, t, fieldName);
                        continue;
                    }
                    Object fieldValue = ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(this.modelType, (String)fieldName).getReadMethod(), t);
                    String highLightFieldValue = highlighter.getBestFragment(this.analyzer, fieldName, String.valueOf(fieldValue));
                    if (highLightFieldValue == null) continue;
                    ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(this.modelType, (String)fieldName).getWriteMethod(), t, (Object[])new Object[]{highLightFieldValue});
                }
                catch (Exception e) {
                    log.error("\u9ad8\u4eae\u663e\u793a\u5173\u952e\u5b57\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private void hightLightField(Analyzer analyzer, Class<?> modelType, Highlighter highlighter, Object t, String fieldName) throws NoSuchFieldException, IOException, InvalidTokenOffsetsException {
        if (fieldName.contains(".")) {
            String[] split = fieldName.split("\\.");
            String pfieldName = split[0];
            Object fieldValue = ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(modelType, (String)pfieldName).getReadMethod(), (Object)t);
            Class<?> fieldType = modelType.getDeclaredField(pfieldName).getType();
            String propertyName = split[1];
            this.hightLightField(analyzer, fieldType, highlighter, fieldValue, propertyName);
        } else {
            String highLightFieldValue;
            Object fieldValue = ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(modelType, (String)fieldName).getReadMethod(), (Object)t);
            String text = String.valueOf(fieldValue);
            if (!text.contains(this.preTag) && (highLightFieldValue = highlighter.getBestFragment(analyzer, fieldName, text)) != null) {
                ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(modelType, (String)fieldName).getWriteMethod(), (Object)t, (Object[])new Object[]{highLightFieldValue});
            }
        }
    }
}

