/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.data.query.jpa;

import cn.bestwu.framework.data.annotation.HighLight;
import cn.bestwu.framework.data.query.ResultHandler;
import cn.bestwu.framework.data.query.SearchRepository;
import cn.bestwu.framework.data.query.jpa.HighlightResultHandler;
import cn.bestwu.framework.data.query.jpa.JpaSearchFieldUtil;
import cn.bestwu.framework.data.util.EntityManagerUtil;
import cn.bestwu.framework.event.BeforeSearchEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.exception.EmptyQueryException;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class JpaSearchRepository
implements SearchRepository {
    private Map<Class, String[]> fieldsCache = new HashMap<Class, String[]>();
    private Map<Class, String[]> highlightFieldsCache = new HashMap<Class, String[]>();
    private final EntityManager entityManager;
    private final ApplicationEventPublisher publisher;

    public JpaSearchRepository(EntityManager entityManager, ApplicationEventPublisher publisher) {
        this.entityManager = entityManager;
        this.publisher = publisher;
    }

    private <T> String[] getSearchFields(Class<T> modelType) {
        String[] fields;
        if (this.fieldsCache.containsKey(modelType)) {
            fields = this.fieldsCache.get(modelType);
        } else {
            fields = JpaSearchFieldUtil.getAnnotationedFields(modelType, Field.class);
            if (fields.length == 0) {
                throw new RuntimeException("\u641c\u7d22\u7684\u7c7b\u578b" + modelType + "\u6ca1\u6709\u6807\u6ce8\u7d22\u5f15\u5b57\u6bb5,\u8bf7\u4f7f\u7528org.hibernate.search.annotations.Field\u6807\u6ce8");
            }
            this.fieldsCache.put(modelType, fields);
        }
        return fields;
    }

    private <T> String[] getHighLightFields(Class<T> modelType) {
        String[] highLightFields;
        if (this.highlightFieldsCache.containsKey(modelType)) {
            highLightFields = this.highlightFieldsCache.get(modelType);
        } else {
            highLightFields = JpaSearchFieldUtil.getAnnotationedFields(modelType, HighLight.class);
            if (highLightFields.length == 0) {
                highLightFields = this.getSearchFields(modelType);
            }
            this.highlightFieldsCache.put(modelType, highLightFields);
        }
        return highLightFields;
    }

    @Override
    public <T> Page search(Class<T> modelType, String keyword, Pageable pageable, ResultHandler resultHandler) {
        try {
            long totalSize;
            List result;
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
            SearchFactory searchFactory = fullTextEntityManager.getSearchFactory();
            QueryBuilder queryBuilder = searchFactory.buildQueryBuilder().forEntity(modelType).get();
            TermMatchingContext termMatchingContext = queryBuilder.keyword().onFields(this.getSearchFields(modelType));
            Query luceneQuery = termMatchingContext.matching((Object)keyword).createQuery();
            FullTextQuery jpaQuery = fullTextEntityManager.createFullTextQuery(luceneQuery, new Class[]{modelType});
            Criteria criteria = EntityManagerUtil.getSession(this.entityManager).createCriteria(modelType);
            this.publisher.publishEvent((ApplicationEvent)new BeforeSearchEvent(criteria, modelType));
            boolean noCriterionEntries = criteria.toString().contains("[][]");
            if (!noCriterionEntries) {
                jpaQuery.setCriteriaQuery(criteria);
            }
            jpaQuery.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
            jpaQuery.setMaxResults(pageable.getPageSize());
            org.springframework.data.domain.Sort sort = pageable.getSort();
            if (sort != null) {
                ArrayList sortFields = new ArrayList();
                sort.forEach(order -> new SortField(order.getProperty(), SortField.Type.SCORE, Sort.Direction.DESC.equals((Object)order.getDirection())));
                jpaQuery.setSort(new Sort(sortFields.toArray(new SortField[sortFields.size()])));
            }
            if ((result = jpaQuery.getResultList()).size() == 0) {
                totalSize = 0L;
            } else if (noCriterionEntries) {
                totalSize = jpaQuery.getResultSize();
            } else {
                criteria.setProjection((Projection)Projections.count((String)"id"));
                totalSize = (Long)criteria.list().get(0);
            }
            if (resultHandler != null) {
                if (resultHandler instanceof HighlightResultHandler) {
                    HighlightResultHandler highlightResultHandler = (HighlightResultHandler)resultHandler;
                    highlightResultHandler.setQuery(luceneQuery);
                    highlightResultHandler.setAnalyzer(searchFactory.getAnalyzer(modelType));
                    highlightResultHandler.setHighLightFields(this.getHighLightFields(modelType));
                    highlightResultHandler.setModelType(modelType);
                }
                resultHandler.accept(result);
            }
            return new PageImpl(result, pageable, totalSize);
        }
        catch (EmptyQueryException ignored) {
            return new PageImpl(Collections.emptyList(), pageable, 0L);
        }
    }
}

