/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.event;

import cn.bestwu.framework.event.AddPredicateEvent;
import cn.bestwu.framework.event.AfterCreateEvent;
import cn.bestwu.framework.event.AfterDeleteEvent;
import cn.bestwu.framework.event.AfterLinkDeleteEvent;
import cn.bestwu.framework.event.AfterLinkSaveEvent;
import cn.bestwu.framework.event.AfterSaveEvent;
import cn.bestwu.framework.event.BeforeCreateEvent;
import cn.bestwu.framework.event.BeforeDeleteEvent;
import cn.bestwu.framework.event.BeforeLinkDeleteEvent;
import cn.bestwu.framework.event.BeforeLinkSaveEvent;
import cn.bestwu.framework.event.BeforeSaveEvent;
import cn.bestwu.framework.event.BeforeSearchEvent;
import cn.bestwu.framework.event.BeforeShowEvent;
import cn.bestwu.framework.event.DefaultPredicateEvent;
import cn.bestwu.framework.event.DefaultSortEvent;
import cn.bestwu.framework.event.ItemResourceEvent;
import cn.bestwu.framework.event.LinkedEvent;
import cn.bestwu.framework.event.RepositoryEvent;
import cn.bestwu.framework.event.annotation.HandleAddPredicate;
import cn.bestwu.framework.event.annotation.HandleAfterCreate;
import cn.bestwu.framework.event.annotation.HandleAfterDelete;
import cn.bestwu.framework.event.annotation.HandleAfterLinkDelete;
import cn.bestwu.framework.event.annotation.HandleAfterLinkSave;
import cn.bestwu.framework.event.annotation.HandleAfterSave;
import cn.bestwu.framework.event.annotation.HandleBeforeCreate;
import cn.bestwu.framework.event.annotation.HandleBeforeDelete;
import cn.bestwu.framework.event.annotation.HandleBeforeLinkDelete;
import cn.bestwu.framework.event.annotation.HandleBeforeLinkSave;
import cn.bestwu.framework.event.annotation.HandleBeforeSave;
import cn.bestwu.framework.event.annotation.HandleBeforeSearch;
import cn.bestwu.framework.event.annotation.HandleBeforeShow;
import cn.bestwu.framework.event.annotation.HandleDefaultPredicate;
import cn.bestwu.framework.event.annotation.HandleDefaultSort;
import cn.bestwu.framework.event.annotation.HandleItemResource;
import cn.bestwu.framework.event.annotation.RestEventHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class AnnotatedEventHandlerInvoker
implements ApplicationListener<RepositoryEvent>,
BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatedEventHandlerInvoker.class);
    private static final String PARAMETER_MISSING = "Invalid event handler method %s! At least a single argument is required to determine the domain type for which you are interested in events.";
    private final MultiValueMap<Class<?>, EventHandlerMethod> handlerMethods = new LinkedMultiValueMap();
    public static final ReflectionUtils.MethodFilter USER_METHODS = method -> !method.isSynthetic() && !method.isBridge() && !ReflectionUtils.isObjectMethod((Method)method) && !ClassUtils.isCglibProxyClass(method.getDeclaringClass()) && !ReflectionUtils.isCglibRenamedMethod((Method)method);

    public void onApplicationEvent(RepositoryEvent event) {
        Class<?> modelType = event.getModelType();
        if (!this.handlerMethods.containsKey(modelType)) {
            return;
        }
        Object src = event.getSource();
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(src);
        if (event instanceof LinkedEvent) {
            parameters.add(((LinkedEvent)event).getLinked());
        }
        Object[] args = parameters.toArray();
        Class<?> eventType = ((Object)((Object)event)).getClass();
        for (EventHandlerMethod handlerMethod : (List)this.handlerMethods.get(modelType)) {
            if (!handlerMethod.eventType.equals(eventType)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invoking {} handler for {}.", (Object)((Object)((Object)event)).getClass().getSimpleName(), event.getSource());
            }
            ReflectionUtils.invokeMethod((Method)handlerMethod.method, (Object)handlerMethod.handler, (Object[])args);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanType = ClassUtils.getUserClass((Object)bean);
        RestEventHandler typeAnno = (RestEventHandler)AnnotationUtils.findAnnotation((Class)beanType, RestEventHandler.class);
        if (typeAnno == null) {
            return bean;
        }
        ReflectionUtils.doWithMethods((Class)beanType, method -> {
            this.inspect(bean, method, HandleBeforeCreate.class, BeforeCreateEvent.class);
            this.inspect(bean, method, HandleAfterCreate.class, AfterCreateEvent.class);
            this.inspect(bean, method, HandleBeforeSave.class, BeforeSaveEvent.class);
            this.inspect(bean, method, HandleBeforeShow.class, BeforeShowEvent.class);
            this.inspect(bean, method, HandleAfterSave.class, AfterSaveEvent.class);
            this.inspect(bean, method, HandleBeforeLinkSave.class, BeforeLinkSaveEvent.class);
            this.inspect(bean, method, HandleAfterLinkSave.class, AfterLinkSaveEvent.class);
            this.inspect(bean, method, HandleBeforeDelete.class, BeforeDeleteEvent.class);
            this.inspect(bean, method, HandleAfterDelete.class, AfterDeleteEvent.class);
            this.inspect(bean, method, HandleBeforeLinkDelete.class, BeforeLinkDeleteEvent.class);
            this.inspect(bean, method, HandleAfterLinkDelete.class, AfterLinkDeleteEvent.class);
            this.inspect(bean, method, HandleItemResource.class, ItemResourceEvent.class);
            this.inspect(bean, method, HandleDefaultSort.class, DefaultSortEvent.class);
            this.inspect(bean, method, HandleDefaultPredicate.class, DefaultPredicateEvent.class);
            this.inspect(bean, method, HandleAddPredicate.class, AddPredicateEvent.class);
            this.inspect(bean, method, HandleBeforeSearch.class, BeforeSearchEvent.class);
        }, (ReflectionUtils.MethodFilter)USER_METHODS);
        return bean;
    }

    private <T extends Annotation> void inspect(Object handler, Method method, Class<T> annotationType, Class<? extends RepositoryEvent> eventType) {
        Annotation annotation = AnnotationUtils.findAnnotation((Method)method, annotationType);
        if (annotation == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            throw new IllegalStateException(String.format(PARAMETER_MISSING, method));
        }
        Class<?> modelType = annotationType.equals(HandleDefaultSort.class) ? ((HandleDefaultSort)annotation).value() : (annotationType.equals(HandleDefaultPredicate.class) ? ((HandleDefaultPredicate)annotation).value() : (annotationType.equals(HandleAddPredicate.class) ? ((HandleAddPredicate)annotation).value() : (annotationType.equals(HandleBeforeSearch.class) ? ((HandleBeforeSearch)annotation).value() : parameterTypes[0])));
        EventHandlerMethod handlerMethod = new EventHandlerMethod(eventType, handler, method);
        this.handlerMethods.add(modelType, (Object)handlerMethod);
    }

    static class EventHandlerMethod {
        final Class<? extends RepositoryEvent> eventType;
        final Method method;
        final Object handler;

        private EventHandlerMethod(Class<? extends RepositoryEvent> eventType, Object handler, Method method) {
            this.eventType = eventType;
            this.method = method;
            this.handler = handler;
            ReflectionUtils.makeAccessible((Method)this.method);
        }

        public String toString() {
            return String.format("EventHandlerMethod{ eventType=%s, method=%s, handler=%s }", this.eventType, this.method, this.handler);
        }
    }
}

