/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.aspect;

import cn.bestwu.framework.event.LogEvent;
import cn.bestwu.framework.rest.support.Log;
import cn.bestwu.framework.rest.support.PrincipalNamePutEvent;
import cn.bestwu.framework.rest.support.RequestJsonViewResponseBodyAdvice;
import cn.bestwu.framework.rest.support.Resource;
import cn.bestwu.framework.util.ResourceUtil;
import cn.bestwu.framework.util.StringUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.ServletServerHttpRequest;

@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final String PUT_PARAMETER_MAP = "PUT_PARAMETER_MAP";
    private final String PRINCIPAL_NAME = "PRINCIPAL_NAME";
    protected ApplicationEventPublisher publisher;
    @Autowired(required=false)
    protected HttpServletRequest request;
    @Autowired(required=false)
    private RequestJsonViewResponseBodyAdvice requestJsonViewResponseBodyAdvice;

    public LogAspect(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @AfterThrowing(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void afterThrowing() {
        Resource<String> source = new Resource<String>();
        this.publisher.publishEvent((ApplicationEvent)new PrincipalNamePutEvent(source));
        this.request.setAttribute("PRINCIPAL_NAME", (Object)source.getContent());
        if ("PUT".equals(this.request.getMethod())) {
            this.request.setAttribute("PUT_PARAMETER_MAP", (Object)this.request.getParameterMap());
        }
    }

    @AfterReturning(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)", returning="result")
    public void log(Object result) {
        if (log.isInfoEnabled()) {
            String principalName;
            String ipAddress = this.request.getRemoteAddr();
            String servletPath = (String)this.request.getAttribute("javax.servlet.forward.servlet_path");
            if (servletPath == null) {
                servletPath = this.request.getServletPath();
            }
            if ((principalName = (String)this.request.getAttribute("PRINCIPAL_NAME")) == null) {
                Resource<String> source = new Resource<String>();
                this.publisher.publishEvent((ApplicationEvent)new PrincipalNamePutEvent(source));
                principalName = source.getContent();
            }
            String requestMethod = this.request.getMethod();
            Map parameterMap = null;
            try {
                if ("PUT".equals(requestMethod)) {
                    parameterMap = (Map)this.request.getAttribute("PUT_PARAMETER_MAP");
                }
                if (parameterMap == null) {
                    parameterMap = this.request.getParameterMap();
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u51fa\u9519", (Throwable)e);
                }
                parameterMap = null;
            }
            ServletServerHttpRequest servletServerHttpRequest = new ServletServerHttpRequest(this.request);
            HttpHeaders headers = servletServerHttpRequest.getHeaders();
            String MSG_CODE = "{} \u7684 [{}] {} {} \nrequest headers:\n{} \nrequest parameters:\n{} \nresponse:\n{}";
            principalName = principalName == null ? (this.request.getRemoteUser() == null ? "anonymousUser" : this.request.getRemoteUser()) : principalName;
            String requestSignature = ResourceUtil.getRequestSignature(this.request);
            if (log.isDebugEnabled()) {
                String resultStr;
                if ("get_logs_index".equals(requestSignature)) {
                    resultStr = StringUtil.subString(result.toString(), 100);
                } else {
                    if (this.requestJsonViewResponseBodyAdvice != null) {
                        MappingJacksonValue mappingJacksonValue = new MappingJacksonValue(result);
                        this.requestJsonViewResponseBodyAdvice.beforeBodyWrite(mappingJacksonValue, this.request);
                        result = mappingJacksonValue;
                    }
                    resultStr = StringUtil.valueOf(result, true);
                }
                log.info(MSG_CODE, new Object[]{ipAddress, principalName, requestMethod, servletPath, StringUtil.valueOf(headers, true), StringUtil.valueOf(parameterMap, true), resultStr});
            } else {
                log.info(MSG_CODE, new Object[]{ipAddress, principalName, requestMethod, servletPath, StringUtil.valueOf(headers, true), StringUtil.subString(StringUtil.valueOf(parameterMap), 100), StringUtil.subString(String.valueOf(result), 100)});
            }
            Log log = new Log();
            log.setIpAddress(ipAddress);
            log.setParameters(StringUtil.valueOf(parameterMap, true));
            log.setRequestMethod(requestMethod);
            log.setRequestSignature(requestSignature);
            log.setServletPath(servletPath);
            log.setRequestHeaders(StringUtil.valueOf(headers, true));
            log.setPrincipalName(principalName);
            this.publisher.publishEvent((ApplicationEvent)new LogEvent(log));
        }
    }
}

