/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.controller;

import cn.bestwu.api.sign.ApiSign;
import cn.bestwu.framework.event.AfterCreateEvent;
import cn.bestwu.framework.event.AfterDeleteEvent;
import cn.bestwu.framework.event.AfterLinkSaveEvent;
import cn.bestwu.framework.event.AfterSaveEvent;
import cn.bestwu.framework.event.BeforeCreateEvent;
import cn.bestwu.framework.event.BeforeDeleteEvent;
import cn.bestwu.framework.event.BeforeSaveEvent;
import cn.bestwu.framework.event.BeforeShowEvent;
import cn.bestwu.framework.rest.annotation.RepositoryRestController;
import cn.bestwu.framework.rest.controller.BaseController;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import cn.bestwu.framework.rest.support.ETag;
import cn.bestwu.framework.rest.support.PersistentEntityResource;
import cn.bestwu.framework.rest.support.ResourceType;
import cn.bestwu.framework.rest.support.RootResourceInformation;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.MethodParameter;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@ApiSign
@RepositoryRestController
@RequestMapping(value={"/{repository}"})
public class RepositoryEntityController
extends BaseController {
    private static final String LINK_HEADER = "Link";
    private static final List<String> ACCEPT_PATCH_HEADERS = Collections.singletonList("application/json");

    @RequestMapping(method={RequestMethod.HEAD})
    public ResponseEntity<?> headCollectionResource(RootResourceInformation resourceInformation) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(LINK_HEADER, this.getBaseLinkBuilder(resourceInformation.getPathName()).withSelfRel().toString());
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.HEAD})
    public ResponseEntity<?> headForItemResource(RootResourceInformation resourceInformation, @PathVariable String id) {
        Object domainObject = this.getItemResource(resourceInformation, id);
        HttpHeaders headers = this.prepareHeaders(resourceInformation.getEntity(), domainObject);
        headers.add(LINK_HEADER, ((ControllerLinkBuilder)this.getBaseLinkBuilder(resourceInformation.getPathName()).slash((Object)id)).withSelfRel().toString());
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.NO_CONTENT);
    }

    @RequestMapping(method={RequestMethod.OPTIONS})
    public ResponseEntity<?> optionsForCollectionResource(RootResourceInformation information) {
        HttpHeaders headers = new HttpHeaders();
        Set<HttpMethod> supportedMethods = information.getResourceMetadata().getSupportedHttpMethods(ResourceType.COLLECTION);
        headers.setAllow(supportedMethods);
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.OPTIONS})
    public ResponseEntity<?> optionsForItemResource(RootResourceInformation information) {
        HttpHeaders headers = new HttpHeaders();
        Set<HttpMethod> supportedMethods = information.getResourceMetadata().getSupportedHttpMethods(ResourceType.ITEM);
        headers.setAllow(supportedMethods);
        headers.put("Accept-Patch", ACCEPT_PATCH_HEADERS);
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/search/{search}"}, method={RequestMethod.GET})
    public Object searchMethod(RootResourceInformation resourceInformation, @RequestParam MultiValueMap<String, Object> parameters, @PathVariable String search, Pageable pageable) throws NoSuchMethodException {
        Method searchMethod = resourceInformation.getResourceMetadata().getSearchMethod(search);
        if (searchMethod == null) {
            throw new ResourceNotFoundException();
        }
        this.request.setAttribute("request_repository_search_name", (Object)search);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        LinkedMultiValueMap result = new LinkedMultiValueMap(parameters);
        MethodParameters methodParameters = new MethodParameters(searchMethod, new AnnotationAttribute(Param.class));
        for (Map.Entry entry : parameters.entrySet()) {
            MethodParameter parameter = methodParameters.getParameter((String)entry.getKey());
            if (parameter == null) continue;
            result.put((Object)parameter.getParameterName(), entry.getValue());
        }
        Object o = invoker.invokeQueryMethod(searchMethod, (MultiValueMap)result, pageable, null);
        if (o == null) {
            throw new ResourceNotFoundException();
        }
        Link selfLink = ControllerLinkBuilder.linkTo(RepositoryEntityController.class, (Method)RepositoryEntityController.class.getMethod("searchMethod", RootResourceInformation.class, MultiValueMap.class, String.class, Pageable.class), (Object[])new Object[]{resourceInformation.getPathName(), search}).withSelfRel();
        return this.ok(new PersistentEntityResource<Object>(o, resourceInformation.getEntity(), selfLink));
    }

    @RequestMapping(method={RequestMethod.GET})
    public Object index(RootResourceInformation resourceInformation, Pageable pageable, boolean all) {
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        pageable = this.getDefaultPageable(pageable, resourceInformation.getModelType());
        Iterable results = all && resourceInformation.getResourceMetadata().enableAllDataInOnePage() ? invoker.invokeFindAll(pageable.getSort()) : invoker.invokeFindAll(pageable);
        return this.ok(new PersistentEntityResource<Iterable>(results, resourceInformation.getEntity(), this.getBaseLinkBuilder(resourceInformation.getPathName()).withSelfRel()));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public Object show(RootResourceInformation resourceInformation, @PathVariable String id) {
        Object content = this.getItemResource(resourceInformation, id);
        this.publisher.publishEvent((ApplicationEvent)new BeforeShowEvent(content));
        return this.ok(new PersistentEntityResource<Object>(content, resourceInformation.getEntity(), new Link[0]));
    }

    private Object getItemResource(RootResourceInformation resourceInformation, @PathVariable String id) {
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Object content = invoker.invokeFindOne((Serializable)((Object)id));
        if (content == null) {
            throw new ResourceNotFoundException();
        }
        return content;
    }

    @RequestMapping(method={RequestMethod.POST})
    public Object create(RootResourceInformation resourceInformation, @Valid PersistentEntityResource resource) {
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Object content = resource.getContent();
        this.publisher.publishEvent((ApplicationEvent)new BeforeCreateEvent(content));
        invoker.invokeSave(content);
        this.publisher.publishEvent((ApplicationEvent)new AfterCreateEvent(content));
        return this.created(resource);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public Object update(RootResourceInformation resourceInformation, @Valid PersistentEntityResource resource, @PathVariable String id, ETag eTag) {
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Object content = resource.getContent();
        eTag.verify(resourceInformation.getEntity(), resourceInformation.getModelType());
        this.publisher.publishEvent((ApplicationEvent)new BeforeSaveEvent(content));
        invoker.invokeSave(content);
        this.publisher.publishEvent((ApplicationEvent)new AfterSaveEvent(content));
        this.publisher.publishEvent((ApplicationEvent)new AfterLinkSaveEvent(content, this.getOldModel()));
        return this.updated(resource);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public Object destroy(RootResourceInformation resourceInformation, @PathVariable String id) {
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Object one = invoker.invokeFindOne((Serializable)((Object)id));
        if (one == null) {
            throw new ResourceNotFoundException();
        }
        this.publisher.publishEvent((ApplicationEvent)new BeforeDeleteEvent(one));
        invoker.invokeDelete((Serializable)((Object)id));
        this.publisher.publishEvent((ApplicationEvent)new AfterDeleteEvent(one));
        return this.noContent();
    }

    @RequestMapping(method={RequestMethod.DELETE})
    public Object batchDestroy(RootResourceInformation resourceInformation, String ... id) throws IllegalAccessException, InstantiationException {
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        if (id == null) {
            throw new IllegalArgumentException(this.getText("param.notnull", "id"));
        }
        Arrays.stream(id).forEach(i -> {
            try {
                Object one = invoker.invokeFindOne((Serializable)((Object)i));
                if (one == null) {
                    throw new ResourceNotFoundException();
                }
                this.publisher.publishEvent((ApplicationEvent)new BeforeDeleteEvent(one));
                invoker.invokeDelete((Serializable)((Object)i));
                this.publisher.publishEvent((ApplicationEvent)new AfterDeleteEvent(one));
            }
            catch (ResourceNotFoundException | EmptyResultDataAccessException throwable) {
                // empty catch block
            }
        });
        return this.noContent();
    }
}

