/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.mapping;

import cn.bestwu.framework.rest.support.RepositoryResourceMetadata;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;

public class RepositoryResourceMappings {
    private final Map<String, RepositoryResourceMetadata> cache = new HashMap<String, RepositoryResourceMetadata>();

    public RepositoryResourceMappings(Repositories repositories) {
        this.populateCache(repositories);
    }

    private void populateCache(Repositories repositories) {
        repositories.forEach(entityClass -> {
            RepositoryInformation repositoryInformation = repositories.getRepositoryInformationFor(entityClass);
            Class repositoryInterface = repositoryInformation.getRepositoryInterface();
            PersistentEntity entity = repositories.getPersistentEntity(entityClass);
            RepositoryResourceMetadata repositoryResourceMetadata = new RepositoryResourceMetadata(entity, repositoryInterface, repositoryInformation.getCrudMethods());
            String pathName = repositoryResourceMetadata.getPathName();
            if (!this.hasMetadataFor(pathName)) {
                this.cache.put(pathName, repositoryResourceMetadata);
            }
        });
    }

    public RepositoryResourceMetadata getRepositoryResourceMetadata(String basePathName) {
        return this.cache.get(basePathName);
    }

    protected final boolean hasMetadataFor(String basePathName) {
        return this.cache.containsKey(basePathName);
    }
}

