/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.resolver;

import cn.bestwu.framework.rest.annotation.Model;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import cn.bestwu.framework.util.StringUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.Introspector;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UriTemplate;

public class ModelMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(ModelMethodArgumentResolver.class);
    private final List<AbstractJackson2HttpMessageConverter> messageConverters;
    private final RepositoryInvokerFactory invokerFactory;
    private final String idParameterName = (String)new UriTemplate("/{id}").getVariableNames().get(0);
    public static final String OLD_MODEL = "OLD_MODEL";

    public ModelMethodArgumentResolver(RepositoryInvokerFactory invokerFactory, List<AbstractJackson2HttpMessageConverter> messageConverters) {
        this.invokerFactory = invokerFactory;
        this.messageConverters = messageConverters;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(Model.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Class modelType = parameter.getParameterType();
        Object model = this.resolveModel(parameter, mavContainer, webRequest, binderFactory, modelType);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u5b9e\u4f53\uff1a" + StringUtil.valueOf(model));
        }
        return model;
    }

    protected Object resolveModel(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory, Class<?> modelClass) throws Exception {
        String name;
        Object content = ((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getMethod().equals(RequestMethod.PUT.name()) ? this.getObjectForUpdate(modelClass, webRequest, binderFactory) : (mavContainer.containsAttribute(name = Introspector.decapitalize(modelClass.getSimpleName())) ? mavContainer.getModel().get((Object)name) : this.createAttribute(name, modelClass, binderFactory, webRequest));
        return this.readObject(parameter, content, mavContainer, webRequest, binderFactory);
    }

    private String getId(String idParameterName, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String[] arg = this.resolveName(idParameterName, webRequest);
        if (arg == null) {
            arg = webRequest.getParameterValues(idParameterName);
        }
        if (binderFactory != null && arg != null) {
            WebDataBinder binder = binderFactory.createBinder(webRequest, null, idParameterName);
            return (String)binder.convertIfNecessary((Object)arg, String.class);
        }
        return null;
    }

    protected Object resolveName(String name, NativeWebRequest request) {
        Map uriTemplateVars = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        return uriTemplateVars != null ? uriTemplateVars.get(name) : null;
    }

    private Object getObjectForUpdate(Class<?> modelClass, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String id = this.getId(this.idParameterName, webRequest, binderFactory);
        if (id == null) {
            throw new IllegalArgumentException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object objectForUpdate = this.invokerFactory.getInvokerFor(modelClass).invokeFindOne((Serializable)((Object)id));
        if (objectForUpdate == null) {
            throw new ResourceNotFoundException();
        }
        Object oldModel = BeanUtils.instantiate(objectForUpdate.getClass());
        BeanUtils.copyProperties((Object)objectForUpdate, (Object)oldModel);
        webRequest.setAttribute(OLD_MODEL, oldModel, 0);
        return objectForUpdate;
    }

    private Object readObject(MethodParameter parameter, Object modelObject, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        WebDataBinder binder;
        HttpServletRequest nativeRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        Class<?> modelType = modelObject.getClass();
        String name = Introspector.decapitalize(modelType.getSimpleName());
        boolean readRequestBody = webRequest.getParameterMap().isEmpty();
        if (readRequestBody) {
            ServletServerHttpRequest request = new ServletServerHttpRequest(nativeRequest);
            MediaType contentType = request.getHeaders().getContentType();
            for (AbstractJackson2HttpMessageConverter messageConverter : this.messageConverters) {
                if (!messageConverter.canRead(modelType, contentType)) continue;
                ObjectMapper mapper = messageConverter.getObjectMapper();
                mapper.readerForUpdating(modelObject).readValue(request.getBody());
                break;
            }
        }
        if ((binder = binderFactory.createBinder(webRequest, modelObject, name)).getTarget() != null) {
            if (!readRequestBody) {
                this.bindRequestParameters(binder, webRequest);
            }
            this.validateIfApplicable(binder, parameter);
            if (binder.getBindingResult().hasErrors()) {
                throw new BindException(binder.getBindingResult());
            }
        }
        Map bindingResultModel = binder.getBindingResult().getModel();
        mavContainer.removeAttributes(bindingResultModel);
        mavContainer.addAllAttributes(bindingResultModel);
        return binder.convertIfNecessary(binder.getTarget(), modelType);
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter methodParam) {
        Annotation[] annotations;
        for (Annotation ann : annotations = methodParam.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            binder.validate(validationHints);
            break;
        }
    }

    protected void bindRequestParameters(WebDataBinder binder, NativeWebRequest request) {
        ServletRequest servletRequest = (ServletRequest)request.getNativeRequest(ServletRequest.class);
        ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
        servletBinder.bind(servletRequest);
    }

    protected final Object createAttribute(String attributeName, Class<?> modelClass, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        Object attribute;
        String value = this.getRequestValueForAttribute(attributeName, request);
        if (value != null && (attribute = this.createAttributeFromRequestValue(value, attributeName, modelClass, binderFactory, request)) != null) {
            return attribute;
        }
        return BeanUtils.instantiateClass(modelClass);
    }

    protected String getRequestValueForAttribute(String attributeName, NativeWebRequest request) {
        if (StringUtils.hasText((String)request.getParameter(attributeName))) {
            return request.getParameter(attributeName);
        }
        return null;
    }

    protected Object createAttributeFromRequestValue(String sourceValue, String attributeName, Class<?> modelClass, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        TypeDescriptor target;
        TypeDescriptor source;
        WebDataBinder binder = binderFactory.createBinder(request, null, attributeName);
        ConversionService conversionService = binder.getConversionService();
        if (conversionService != null && conversionService.canConvert(source = TypeDescriptor.valueOf(String.class), target = TypeDescriptor.valueOf(modelClass))) {
            return binder.convertIfNecessary((Object)sourceValue, modelClass);
        }
        return null;
    }
}

