/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import cn.bestwu.framework.data.annotation.DisableSelfRel;
import cn.bestwu.framework.data.annotation.EnableAllDataInOnePage;
import cn.bestwu.framework.data.annotation.RepositoryRestResource;
import cn.bestwu.framework.data.annotation.SearchResource;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import cn.bestwu.framework.rest.support.ResourceType;
import cn.bestwu.framework.util.ArrayUtil;
import cn.bestwu.framework.util.ResourceUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;

public class RepositoryResourceMetadata {
    private boolean exported = true;
    private String pathName;
    private PersistentEntity<?, ?> entity;
    private Map<ResourceType, Set<HttpMethod>> supportedHttpMethods;
    private Map<String, Method> searchMethods;
    private boolean enableAllDataInOnePage;
    private boolean contained = false;

    public RepositoryResourceMetadata(PersistentEntity<?, ?> entity, Class<?> repositoryInterface, CrudMethods crudMethods) {
        this.entity = entity;
        this.enableAllDataInOnePage = repositoryInterface.isAnnotationPresent(EnableAllDataInOnePage.class);
        Method[] methods = repositoryInterface.getMethods();
        Arrays.stream(methods).forEach(method -> {
            SearchResource searchResource = method.getAnnotation(SearchResource.class);
            if (searchResource != null) {
                String searchResourceName = searchResource.value();
                if (!StringUtils.hasText((String)searchResourceName)) {
                    searchResourceName = StringUtils.uncapitalize((String)method.getName().replace("find", "").replace("findBy", "").replace("query", "").replace("queryBy", ""));
                }
                if (this.searchMethods == null) {
                    this.searchMethods = new HashMap<String, Method>();
                }
                this.searchMethods.put(searchResourceName, (Method)method);
            }
        });
        RepositoryRestResource annotation = repositoryInterface.getAnnotation(RepositoryRestResource.class);
        if (annotation != null) {
            this.exported = annotation.exported();
        } else {
            this.contained = true;
        }
        this.pathName = ResourceUtil.getRepositoryBasePathName(entity.getType());
        if (this.exported) {
            HashMap supportedHttpMethods = new HashMap();
            Method findAllMethod = crudMethods.getFindAllMethod();
            Method findOneMethod = crudMethods.getFindOneMethod();
            Method saveMethod = crudMethods.getSaveMethod();
            Method deleteMethod = crudMethods.getDeleteMethod();
            HashSet<HttpMethod> collectionMethods = new HashSet<HttpMethod>();
            if (this.exposesMethod(findAllMethod, HttpMethod.GET)) {
                collectionMethods.add(HttpMethod.HEAD);
                collectionMethods.add(HttpMethod.GET);
            }
            if (this.exposesMethod(saveMethod, HttpMethod.POST)) {
                collectionMethods.add(HttpMethod.POST);
            }
            if (this.exposesMethod(deleteMethod, HttpMethod.DELETE)) {
                collectionMethods.add(HttpMethod.DELETE);
            }
            if (!collectionMethods.isEmpty()) {
                supportedHttpMethods.put(ResourceType.COLLECTION, Collections.unmodifiableSet(collectionMethods));
            }
            HashSet<HttpMethod> itemMethods = new HashSet<HttpMethod>();
            if (this.exposesMethod(findOneMethod, HttpMethod.GET) && !entity.getType().isAnnotationPresent(DisableSelfRel.class)) {
                itemMethods.add(HttpMethod.HEAD);
                itemMethods.add(HttpMethod.GET);
            }
            if (this.exposesMethod(saveMethod, HttpMethod.PUT)) {
                itemMethods.add(HttpMethod.PUT);
            }
            if (this.exposesMethod(deleteMethod, HttpMethod.DELETE)) {
                itemMethods.add(HttpMethod.DELETE);
            }
            if (!itemMethods.isEmpty()) {
                supportedHttpMethods.put(ResourceType.ITEM, Collections.unmodifiableSet(itemMethods));
            }
            this.supportedHttpMethods = Collections.unmodifiableMap(supportedHttpMethods);
            if (supportedHttpMethods.isEmpty()) {
                this.exported = false;
            }
        }
    }

    private boolean exposesMethod(Method method, HttpMethod httpMethod) {
        if (method == null) {
            return false;
        }
        RepositoryRestResource annotation = method.getAnnotation(RepositoryRestResource.class);
        if (annotation == null) {
            return !this.contained;
        }
        if (!annotation.exported()) {
            return false;
        }
        Object[] array = annotation.value();
        if (array.length == 0) {
            return true;
        }
        return ArrayUtil.contains(array, httpMethod);
    }

    public PersistentEntity<?, ?> getEntity() {
        return this.entity;
    }

    public boolean isExported() {
        return this.exported;
    }

    public String getPathName() {
        return this.pathName;
    }

    public Class<?> getModelType() {
        return this.entity.getType();
    }

    public void verifySupportedMethod(HttpMethod requestHttpMethod, ResourceType resourceType) throws HttpRequestMethodNotSupportedException {
        if (HttpMethod.OPTIONS.equals((Object)requestHttpMethod)) {
            return;
        }
        if (resourceType == null) {
            throw new ResourceNotFoundException();
        }
        Set<HttpMethod> supportedHttpMethods = this.supportedHttpMethods.get((Object)resourceType);
        if (supportedHttpMethods == null || supportedHttpMethods.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        if (!supportedHttpMethods.contains(requestHttpMethod)) {
            throw new HttpRequestMethodNotSupportedException(requestHttpMethod.name(), (Collection)supportedHttpMethods.stream().map(Enum::name).collect(Collectors.toSet()));
        }
    }

    public Set<HttpMethod> getSupportedHttpMethods(ResourceType resourceType) {
        return this.supportedHttpMethods.get((Object)resourceType);
    }

    public boolean enableAllDataInOnePage() {
        return this.enableAllDataInOnePage;
    }

    public Method getSearchMethod(String search) {
        if (CollectionUtils.isEmpty(this.searchMethods)) {
            return null;
        }
        return this.searchMethods.get(search);
    }
}

