/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;

public class UnwrappingRepositoryInvokerFactory
implements RepositoryInvokerFactory {
    private static final List<Converter<Object, Object>> CONVERTERS;
    private final RepositoryInvokerFactory delegate;

    public UnwrappingRepositoryInvokerFactory(RepositoryInvokerFactory delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate RepositoryInvokerFactory must not be null!");
        this.delegate = delegate;
    }

    public RepositoryInvoker getInvokerFor(Class<?> domainType) {
        return new UnwrappingRepositoryInvoker(this.delegate.getInvokerFor(domainType), CONVERTERS);
    }

    static {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        ClassLoader classLoader = UnwrappingRepositoryInvokerFactory.class.getClassLoader();
        if (ClassUtils.isPresent((String)"java.util.Optional", (ClassLoader)classLoader)) {
            converters.add(source -> source instanceof Optional ? ((Optional)source).orElse(null) : source);
        }
        if (ClassUtils.isPresent((String)"com.google.common.base.Optional", (ClassLoader)classLoader)) {
            converters.add(source -> source instanceof com.google.common.base.Optional ? ((com.google.common.base.Optional)source).orNull() : source);
        }
        CONVERTERS = Collections.unmodifiableList(converters);
    }

    private static class UnwrappingRepositoryInvoker
    implements RepositoryInvoker {
        private final RepositoryInvoker delegate;
        private final Collection<Converter<Object, Object>> converters;

        public UnwrappingRepositoryInvoker(RepositoryInvoker delegate, Collection<Converter<Object, Object>> converters) {
            Assert.notNull((Object)delegate, (String)"Delegate RepositoryInvoker must not be null!");
            Assert.notNull(converters, (String)"Converters must not be null!");
            this.delegate = delegate;
            this.converters = converters;
        }

        public <T> T invokeFindOne(Serializable id) {
            return (T)this.postProcess(this.delegate.invokeFindOne(id));
        }

        public Object invokeQueryMethod(Method method, Map<String, String[]> parameters, Pageable pageable, Sort sort) {
            return this.postProcess(this.delegate.invokeQueryMethod(method, parameters, pageable, sort));
        }

        public Object invokeQueryMethod(Method method, MultiValueMap<String, ?> parameters, Pageable pageable, Sort sort) {
            return this.postProcess(this.delegate.invokeQueryMethod(method, parameters, pageable, sort));
        }

        public boolean hasDeleteMethod() {
            return this.delegate.hasDeleteMethod();
        }

        public boolean hasFindAllMethod() {
            return this.delegate.hasFindAllMethod();
        }

        public boolean hasFindOneMethod() {
            return this.delegate.hasFindOneMethod();
        }

        public boolean hasSaveMethod() {
            return this.delegate.hasSaveMethod();
        }

        public void invokeDelete(Serializable id) {
            this.delegate.invokeDelete(id);
        }

        public Iterable<Object> invokeFindAll(Pageable pageable) {
            return this.delegate.invokeFindAll(pageable);
        }

        public Iterable<Object> invokeFindAll(Sort sort) {
            return this.delegate.invokeFindAll(sort);
        }

        public <T> T invokeSave(T object) {
            return (T)this.delegate.invokeSave(object);
        }

        private Object postProcess(Object result) {
            for (Converter<Object, Object> converter : this.converters) {
                result = converter.convert(result);
            }
            return result;
        }
    }
}

