/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.support.client;

import cn.bestwu.framework.support.client.PushbackBodyClientHttpResponseWrapper;
import cn.bestwu.framework.support.client.UTF8AllEncompassingFormHttpMessageConverter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class CustomRestTemplate
extends RestTemplate {
    private boolean print;
    private static Charset defaultCharset = Charset.forName("UTF-8");

    public void setPrint(boolean print) {
        this.print = print;
    }

    public CustomRestTemplate() {
        this(null, null);
    }

    public CustomRestTemplate(String username, String password) {
        this.addAuthentication(username, password);
        this.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) {
            }
        });
        boolean romePresent = ClassUtils.isPresent((String)"com.rometools.rome.feed.WireFeed", (ClassLoader)RestTemplate.class.getClassLoader());
        boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)RestTemplate.class.getClassLoader());
        boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)RestTemplate.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)RestTemplate.class.getClassLoader());
        boolean jackson2XmlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)RestTemplate.class.getClassLoader());
        boolean gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)RestTemplate.class.getClassLoader());
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(new ByteArrayHttpMessageConverter());
        messageConverters.add(new StringHttpMessageConverter(defaultCharset));
        messageConverters.add(new ResourceHttpMessageConverter());
        messageConverters.add(new SourceHttpMessageConverter());
        messageConverters.add((Object)new UTF8AllEncompassingFormHttpMessageConverter());
        if (romePresent) {
            messageConverters.add(new AtomFeedHttpMessageConverter());
            messageConverters.add(new RssChannelHttpMessageConverter());
        }
        if (jackson2XmlPresent) {
            messageConverters.add(new MappingJackson2XmlHttpMessageConverter());
        } else if (jaxb2Present) {
            messageConverters.add(new Jaxb2RootElementHttpMessageConverter());
        }
        if (jackson2Present) {
            messageConverters.add(new MappingJackson2HttpMessageConverter());
        } else if (gsonPresent) {
            messageConverters.add(new GsonHttpMessageConverter());
        }
        this.setMessageConverters(messageConverters);
    }

    private void addAuthentication(String username, String password) {
        if (username == null) {
            return;
        }
        List<BasicAuthorizationInterceptor> interceptors = Collections.singletonList(new BasicAuthorizationInterceptor(username, password));
        this.setRequestFactory((ClientHttpRequestFactory)new InterceptingClientHttpRequestFactory(this.getRequestFactory(), interceptors));
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, MediaType mediaType, Object ... urlVariables) throws RestClientException {
        URI expanded = new UriTemplate(url).expand(urlVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor, mediaType);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, MediaType mediaType, Map<String, ?> urlVariables) throws RestClientException {
        URI expanded = new UriTemplate(url).expand(urlVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor, mediaType);
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return this.doExecute(url, method, requestCallback, responseExtractor, null);
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, MediaType mediaType) throws RestClientException {
        Assert.notNull((Object)url, (String)"'url' must not be null");
        Assert.notNull((Object)method, (String)"'method' must not be null");
        try (ClientHttpResponse response = null;){
            ClientHttpRequest request = this.createRequest(url, method);
            if (requestCallback != null) {
                requestCallback.doWithRequest(request);
            }
            HttpHeaders requestHeaders = request.getHeaders();
            if (mediaType != null) {
                requestHeaders.setAccept(Collections.singletonList(mediaType));
            }
            response = request.execute();
            if (this.print && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"------------------------------");
                this.logger.debug((Object)"requestHeaders:");
                requestHeaders.forEach((s, strings) -> this.logger.debug((Object)(s + " : " + strings)));
                this.logger.debug((Object)"------------------------------");
            }
            HttpHeaders responseHeaders = response.getHeaders();
            if (this.print && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"------------------------------");
                this.logger.debug((Object)"responseHeaders:");
                responseHeaders.forEach((s, strings) -> this.logger.debug((Object)(s + " : " + strings)));
                this.logger.debug((Object)"------------------------------");
            }
            this.handleResponse(url, method, response);
            if (responseExtractor != null) {
                if (this.print && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"------------------------------");
                    response = new PushbackBodyClientHttpResponseWrapper(response);
                    this.logger.debug((Object)("responseBody: \n" + ((PushbackBodyClientHttpResponseWrapper)response).readBody()));
                    this.logger.debug((Object)"------------------------------");
                }
                Object object = responseExtractor.extractData(response);
                return (T)object;
            }
            T t = null;
            return t;
        }
    }

    public <T> T getForObject(String url, Class<T> responseType, MediaType mediaType, Object ... urlVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.GET, requestCallback, (ResponseExtractor<T>)responseExtractor, mediaType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, MediaType mediaType, Map<String, ?> urlVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, mediaType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, MediaType mediaType, Object ... urlVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, mediaType, urlVariables);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, MediaType mediaType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.POST, requestCallback, (ResponseExtractor<T>)responseExtractor, mediaType, uriVariables);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, MediaType mediaType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, mediaType, uriVariables);
    }

    public <T> T putForObject(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.PUT, requestCallback, (ResponseExtractor<T>)responseExtractor, null, null, uriVariables);
    }

    public <T> T putForObject(String url, Object request, Class<T> responseType, MediaType mediaType, Object ... uriVariables) {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.PUT, requestCallback, (ResponseExtractor<T>)responseExtractor, mediaType, uriVariables);
    }

    public <T> ResponseEntity<T> putForEntity(String url, Object request, Class<T> responseType, MediaType mediaType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.PUT, requestCallback, responseExtractor, mediaType, uriVariables);
    }

    public <T> ResponseEntity<T> putForEntity(String url, Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor responseExtractor = this.responseEntityExtractor(responseType);
        return (ResponseEntity)this.execute(url, HttpMethod.PUT, requestCallback, responseExtractor, null, uriVariables);
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, MediaType mediaType, Object ... uriVariables) throws RestClientException {
        ResponseExtractor responseExtractor = this.responseEntityExtractor(null);
        return (ResponseEntity)this.execute(url, HttpMethod.DELETE, null, responseExtractor, mediaType, uriVariables);
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, MediaType mediaType, Map<String, ?> urlVariables) throws RestClientException {
        ResponseExtractor responseExtractor = this.responseEntityExtractor(null);
        return (ResponseEntity)this.execute(url, HttpMethod.DELETE, null, responseExtractor, mediaType, urlVariables);
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, Object ... uriVariables) throws RestClientException {
        ResponseExtractor responseExtractor = this.responseEntityExtractor(null);
        return (ResponseEntity)this.execute(url, HttpMethod.DELETE, null, responseExtractor, null, uriVariables);
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, Map<String, ?> urlVariables) throws RestClientException {
        ResponseExtractor responseExtractor = this.responseEntityExtractor(null);
        return (ResponseEntity)this.execute(url, HttpMethod.DELETE, null, responseExtractor, null, urlVariables);
    }

    private static class BasicAuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private final String username;
        private final String password;

        BasicAuthorizationInterceptor(String username, String password) {
            this.username = username;
            this.password = password == null ? "" : password;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            String token = Base64Utils.encodeToString((byte[])(this.username + ":" + this.password).getBytes(defaultCharset));
            request.getHeaders().add("Authorization", "Basic " + token);
            return execution.execute(request, body);
        }
    }
}

