/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.util;

import cn.bestwu.framework.data.annotation.PathName;
import cn.bestwu.framework.rest.support.Version;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.atteo.evo.inflector.English;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

public class ResourceUtil {
    public static final String SEPARATOR = ",";
    private static AnnotationMappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(RequestMapping.class);

    public static String getRepositoryBasePathName(Class<?> clazz) {
        PathName pathName = clazz.getAnnotation(PathName.class);
        if (pathName != null) {
            return pathName.value();
        }
        return English.plural((String)StringUtils.uncapitalize((String)clazz.getSimpleName()));
    }

    public static String getRequestSignature(HttpServletRequest request) {
        String searchName;
        HandlerMethod handlerMethod = (HandlerMethod)request.getAttribute("request_handler_method");
        if (handlerMethod == null) {
            return null;
        }
        String apiSignature = request.getMethod().toLowerCase() + DISCOVERER.getMapping(handlerMethod.getMethod());
        String repositoryBasePathName = (String)request.getAttribute("request_repository_base_path_name");
        if (repositoryBasePathName != null) {
            apiSignature = apiSignature.replace("{repository}", repositoryBasePathName);
        }
        if ((searchName = (String)request.getAttribute("request_repository_search_name")) != null) {
            apiSignature = apiSignature.replace("{search}", searchName);
        }
        apiSignature = apiSignature.replaceAll("[{}]", "").replace("/", "_");
        return apiSignature;
    }

    public static String getRequestVersion(HttpServletRequest request) {
        String request_version_key = "REQUEST_VERSION";
        String version = (String)request.getAttribute(request_version_key);
        if (version == null) {
            Enumeration accept = request.getHeaders("Accept");
            while (accept.hasMoreElements()) {
                String s;
                String[] split;
                String element = (String)accept.nextElement();
                String[] stringArray = split = element.split(SEPARATOR);
                int n = stringArray.length;
                for (int i = 0; i < n && !StringUtils.hasText((String)(version = MediaType.valueOf((String)(s = stringArray[i])).getParameter("version"))); ++i) {
                }
            }
            if (!StringUtils.hasText((String)version)) {
                version = request.getParameter("_version");
            }
            if (!StringUtils.hasText((String)version)) {
                version = "1.0";
            }
            request.setAttribute(request_version_key, (Object)version);
        }
        return version;
    }

    public static boolean equalsVersion(HttpServletRequest request, String verion) {
        return Version.equals(verion, ResourceUtil.getRequestVersion(request));
    }
}

