/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.data.query.jpa;

import cn.bestwu.framework.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.annotations.IndexedEmbedded;

public class JpaSearchFieldUtil {
    public static <T> String[] getAnnotationedFields(Class<T> modelType, Class<? extends Annotation> AnnotationType2) {
        HashSet fields = new HashSet();
        Arrays.stream(modelType.getDeclaredFields()).forEach(field -> JpaSearchFieldUtil.addAnnotationedFields(fields, field, AnnotationType2, null));
        return fields.toArray(new String[fields.size()]);
    }

    private static void addAnnotationedFields(Set<String> fields, Field field, Class<? extends Annotation> annotationType, String parentFieldName) {
        IndexedEmbedded annotation;
        String fieldName = field.getName();
        if (parentFieldName != null) {
            fieldName = parentFieldName + "." + fieldName;
        }
        if (field.isAnnotationPresent(annotationType)) {
            fields.add(fieldName);
        } else if (field.isAnnotationPresent(IndexedEmbedded.class) && (annotation = field.getAnnotation(IndexedEmbedded.class)).depth() > StringUtil.countSubString(fieldName, ".")) {
            for (Field fieldField : field.getType().getDeclaredFields()) {
                JpaSearchFieldUtil.addAnnotationedFields(fields, fieldField, annotationType, fieldName);
            }
        }
    }
}

