/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.data.query.jpa;

import cn.bestwu.framework.data.annotation.HighLight;
import cn.bestwu.framework.data.query.ResultHandler;
import cn.bestwu.framework.data.query.SearchRepository;
import cn.bestwu.framework.data.query.jpa.HighlightResultHandler;
import cn.bestwu.framework.data.query.jpa.JpaSearchFieldUtil;
import cn.bestwu.framework.data.util.EntityManagerUtil;
import cn.bestwu.framework.event.BeforeSearchEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Criteria;
import org.hibernate.QueryTimeoutException;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.exception.EmptyQueryException;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class JpaSearchRepository
implements SearchRepository {
    private Map<Class, String[]> fieldsCache = new HashMap<Class, String[]>();
    private Map<Class, String[]> highlightFieldsCache = new HashMap<Class, String[]>();
    private final EntityManager entityManager;
    private final ApplicationEventPublisher publisher;
    private static final TimeoutExceptionFactory exceptionFactory = (message, queryDescription) -> new QueryTimeoutException(message, null, queryDescription);

    public JpaSearchRepository(EntityManager entityManager, ApplicationEventPublisher publisher) {
        this.entityManager = entityManager;
        this.publisher = publisher;
    }

    private <T> String[] getSearchFields(Class<T> modelType) {
        String[] fields;
        if (this.fieldsCache.containsKey(modelType)) {
            fields = this.fieldsCache.get(modelType);
        } else {
            fields = JpaSearchFieldUtil.getAnnotationedFields(modelType, Field.class);
            if (fields.length == 0) {
                throw new RuntimeException("\u641c\u7d22\u7684\u7c7b\u578b" + modelType + "\u6ca1\u6709\u6807\u6ce8\u7d22\u5f15\u5b57\u6bb5,\u8bf7\u4f7f\u7528org.hibernate.search.annotations.Field\u6807\u6ce8");
            }
            this.fieldsCache.put(modelType, fields);
        }
        return fields;
    }

    private <T> String[] getHighLightFields(Class<T> modelType) {
        String[] highLightFields;
        if (this.highlightFieldsCache.containsKey(modelType)) {
            highLightFields = this.highlightFieldsCache.get(modelType);
        } else {
            highLightFields = JpaSearchFieldUtil.getAnnotationedFields(modelType, HighLight.class);
            if (highLightFields.length == 0) {
                highLightFields = this.getSearchFields(modelType);
            }
            this.highlightFieldsCache.put(modelType, highLightFields);
        }
        return highLightFields;
    }

    @Override
    public <T> Page search(Class<T> modelType, String keyword, Pageable pageable, ResultHandler resultHandler) {
        try {
            List result;
            long totalSize;
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
            SearchFactory searchFactory = fullTextEntityManager.getSearchFactory();
            QueryBuilder queryBuilder = searchFactory.buildQueryBuilder().forEntity(modelType).get();
            TermMatchingContext termMatchingContext = queryBuilder.keyword().onFields(this.getSearchFields(modelType));
            Query luceneQuery = termMatchingContext.matching((Object)keyword).createQuery();
            Criteria criteria = EntityManagerUtil.getSession(this.entityManager).createCriteria(modelType);
            this.publisher.publishEvent((ApplicationEvent)new BeforeSearchEvent(criteria, modelType));
            boolean noCriterionEntries = criteria.toString().contains("[][]");
            org.springframework.data.domain.Sort sort = pageable.getSort();
            if (noCriterionEntries) {
                FullTextQuery jpaQuery = fullTextEntityManager.createFullTextQuery(luceneQuery, new Class[]{modelType});
                totalSize = jpaQuery.getResultSize();
                if (totalSize > 0L) {
                    if (sort != null) {
                        ArrayList sortFields = new ArrayList();
                        sort.forEach(order -> sortFields.add(new SortField(order.getProperty(), SortField.Type.SCORE, Sort.Direction.DESC.equals((Object)order.getDirection()))));
                        jpaQuery.setSort(new Sort(sortFields.toArray(new SortField[sortFields.size()])));
                    }
                    jpaQuery.setFirstResult(pageable.getOffset());
                    jpaQuery.setMaxResults(pageable.getPageSize());
                    result = jpaQuery.getResultList();
                } else {
                    result = Collections.emptyList();
                }
            } else {
                SessionImplementor sessionImplementor = (SessionImplementor)EntityManagerUtil.getSession(this.entityManager);
                HSQuery hSearchQuery = ContextHelper.getSearchintegratorBySessionImplementor((SessionImplementor)sessionImplementor).createHSQuery();
                hSearchQuery.luceneQuery(luceneQuery).timeoutExceptionFactory(exceptionFactory).tenantIdentifier(sessionImplementor.getTenantIdentifier()).targetedEntities(Arrays.asList(modelType));
                List entityInfos = hSearchQuery.queryEntityInfos();
                if (entityInfos.size() != 0) {
                    ArrayList<Serializable> ids = new ArrayList<Serializable>(entityInfos.size());
                    String idName = null;
                    for (EntityInfo entityInfo : entityInfos) {
                        if (idName == null) {
                            idName = entityInfo.getIdName();
                        }
                        ids.add(entityInfo.getId());
                    }
                    criteria.add(Restrictions.in(idName, ids));
                    criteria.setProjection((Projection)Projections.count((String)"id"));
                    totalSize = (Long)criteria.list().get(0);
                    if (totalSize > 0L) {
                        criteria.setProjection(null);
                        if (sort != null) {
                            sort.forEach(order -> {
                                if (Sort.Direction.DESC.equals((Object)order.getDirection())) {
                                    criteria.addOrder(Order.desc((String)order.getProperty()));
                                } else {
                                    criteria.addOrder(Order.asc((String)order.getProperty()));
                                }
                            });
                        }
                        criteria.setFirstResult(pageable.getOffset());
                        criteria.setMaxResults(pageable.getPageSize());
                        result = criteria.list();
                    } else {
                        result = Collections.emptyList();
                    }
                } else {
                    totalSize = 0L;
                    result = Collections.emptyList();
                }
            }
            if (resultHandler != null) {
                if (resultHandler instanceof HighlightResultHandler) {
                    HighlightResultHandler highlightResultHandler = (HighlightResultHandler)resultHandler;
                    highlightResultHandler.setQuery(luceneQuery);
                    highlightResultHandler.setAnalyzer(searchFactory.getAnalyzer(modelType));
                    highlightResultHandler.setHighLightFields(this.getHighLightFields(modelType));
                    highlightResultHandler.setModelType(modelType);
                }
                resultHandler.accept(result);
            }
            return new PageImpl(result, pageable, totalSize);
        }
        catch (EmptyQueryException ignored) {
            return new PageImpl(Collections.emptyList(), pageable, 0L);
        }
    }
}

