/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.aspect;

import cn.bestwu.framework.event.LogEvent;
import cn.bestwu.framework.rest.support.Log;
import cn.bestwu.framework.rest.support.PrincipalNamePutEvent;
import cn.bestwu.framework.rest.support.Resource;
import cn.bestwu.framework.util.ResourceUtil;
import cn.bestwu.framework.util.StringUtil;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.ServletServerHttpRequest;

@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final String PUT_PARAMETER_MAP = "PUT_PARAMETER_MAP";
    private final String PRINCIPAL_NAME = "PRINCIPAL_NAME";
    protected ApplicationEventPublisher publisher;
    @Autowired(required=false)
    protected HttpServletRequest request;

    public LogAspect(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @AfterThrowing(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void afterThrowing() {
        Resource<String> source = new Resource<String>();
        this.publisher.publishEvent((ApplicationEvent)new PrincipalNamePutEvent(source));
        this.request.setAttribute("PRINCIPAL_NAME", (Object)source.getContent());
        if ("PUT".equals(this.request.getMethod())) {
            this.request.setAttribute("PUT_PARAMETER_MAP", (Object)this.request.getParameterMap());
        }
    }

    @AfterReturning(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)", returning="result")
    public void log(Object result) {
        if (log.isInfoEnabled()) {
            String resultStr;
            String principalName;
            String ipAddress = this.request.getRemoteAddr();
            String servletPath = (String)this.request.getAttribute("javax.servlet.forward.servlet_path");
            if (servletPath == null) {
                servletPath = this.request.getServletPath();
            }
            if ((principalName = (String)this.request.getAttribute("PRINCIPAL_NAME")) == null) {
                Resource<String> source = new Resource<String>();
                this.publisher.publishEvent((ApplicationEvent)new PrincipalNamePutEvent(source));
                principalName = source.getContent();
            }
            String requestMethod = this.request.getMethod();
            Map parameterMap = null;
            try {
                if ("PUT".equals(requestMethod)) {
                    parameterMap = (Map)this.request.getAttribute("PUT_PARAMETER_MAP");
                }
                if (parameterMap == null) {
                    parameterMap = this.request.getParameterMap();
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u51fa\u9519", (Throwable)e);
                }
                parameterMap = null;
            }
            ServletServerHttpRequest servletServerHttpRequest = new ServletServerHttpRequest(this.request);
            HttpHeaders headers = servletServerHttpRequest.getHeaders();
            String MSG_CODE = "{} \u7684 [{}] {} {} \nrequest headers:\n{} \nrequest parameters:\n{} \nresponse:\n{}";
            principalName = principalName == null ? (this.request.getRemoteUser() == null ? "anonymousUser" : this.request.getRemoteUser()) : principalName;
            String requestSignature = ResourceUtil.getRequestSignature(this.request);
            boolean error = false;
            if (result instanceof ResponseEntity) {
                ResponseEntity responseEntity = (ResponseEntity)result;
                HttpStatus statusCode = responseEntity.getStatusCode();
                resultStr = statusCode.is2xxSuccessful() || statusCode.is3xxRedirection() ? statusCode.toString() + " " + statusCode.getReasonPhrase() : "Error:\n" + StringUtil.valueOf(result, true);
                error = statusCode.is5xxServerError();
            } else {
                resultStr = StringUtil.subString(String.valueOf(result), 100);
            }
            if (error) {
                log.error(MSG_CODE, new Object[]{ipAddress, principalName, requestMethod, servletPath, StringUtil.valueOf(headers, true), StringUtil.valueOf(parameterMap, true), resultStr});
            } else {
                log.info(MSG_CODE, new Object[]{ipAddress, principalName, requestMethod, servletPath, StringUtil.valueOf(headers, true), StringUtil.valueOf(parameterMap, true), resultStr});
            }
            Log log = new Log();
            log.setIpAddress(ipAddress);
            log.setParameters(StringUtil.valueOf(parameterMap, true));
            log.setRequestMethod(requestMethod);
            log.setRequestSignature(requestSignature);
            log.setServletPath(servletPath);
            log.setRequestHeaders(StringUtil.valueOf(headers, true));
            log.setPrincipalName(StringUtil.subString(principalName, 220));
            log.setDevice(StringUtil.subString(this.getUserAgent(), 220));
            log.setResponse(resultStr);
            this.publisher.publishEvent((ApplicationEvent)new LogEvent(log));
        }
    }

    public String getUserAgent() {
        Enumeration headers = this.request.getHeaders("user-agent");
        if (headers.hasMoreElements()) {
            return (String)headers.nextElement();
        }
        return null;
    }
}

