/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.controller;

import cn.bestwu.framework.event.DefaultSortEvent;
import cn.bestwu.framework.rest.support.Response;
import cn.bestwu.framework.util.ParameterUtil;
import cn.bestwu.framework.util.ResourceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.util.ClassUtils;

public abstract class BaseController
extends Response {
    public static final String BASE_NAME = "{repository}";
    public static final String ID_URI = "/{id}";
    static final String BASE_URI = "/{repository}";
    @Autowired(required=false)
    private ServletContext servletContext;
    @Autowired
    private MessageSource messageSource;
    @Autowired(required=false)
    protected HttpServletRequest request;
    @Autowired
    private RepositoryInvokerFactory invokerFactory;

    public String getText(Object code, Object ... args) {
        String codeString = String.valueOf(code);
        return this.messageSource.getMessage(codeString, args, codeString, this.request == null ? Locale.CHINA : this.request.getLocale());
    }

    public String getTextDefaultNull(Object code, Object ... args) {
        return this.messageSource.getMessage(String.valueOf(code), args, null, this.request == null ? Locale.CHINA : this.request.getLocale());
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public String getUserAgent() {
        Enumeration headers = this.request.getHeaders("user-agent");
        if (headers.hasMoreElements()) {
            return (String)headers.nextElement();
        }
        return null;
    }

    protected String getDeviceInfo() {
        String user_agent = this.getUserAgent();
        if (user_agent.indexOf("Android") > 0 || user_agent.indexOf("Commons-HttpClient") > 0) {
            return "Android";
        }
        if (user_agent.indexOf("iPhone") > 0) {
            return "iPhone";
        }
        return "WEB";
    }

    protected Pageable getDefaultPageable(Pageable pageable, Sort sort) {
        if (pageable.getSort() == null) {
            pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), sort);
        }
        return pageable;
    }

    protected Pageable getDefaultPageable(Pageable pageable, Class<?> modelType) {
        if (pageable == null) {
            return null;
        }
        if (pageable.getSort() == null) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            this.publisher.publishEvent((ApplicationEvent)new DefaultSortEvent(orders, modelType));
            if (orders.isEmpty()) {
                orders.add(new Sort.Order(Sort.Direction.DESC, this.getPersistentEntity(modelType).getIdProperty().getName()));
            }
            pageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(orders));
        }
        return pageable;
    }

    protected boolean versionEquals(String version) {
        return ResourceUtil.equalsVersion(this.request, version);
    }

    protected boolean versionEndsWith(String suffix) {
        String requestVersion = ResourceUtil.getRequestVersion(this.request);
        return requestVersion != null && (requestVersion.endsWith(suffix.toLowerCase()) || requestVersion.endsWith(suffix.toUpperCase()));
    }

    protected Object getOldModel() {
        String oldModel = "OLD_MODEL";
        return this.request.getAttribute(oldModel);
    }

    protected boolean hasParameter(String key) {
        return ParameterUtil.hasParameter(this.request.getParameterMap(), key);
    }

    protected boolean hasParameterKey(String key) {
        return ParameterUtil.hasParameterKey(this.request.getParameterMap(), key);
    }

    protected <S> void setRelatedProperty(S source, Consumer<S> action) {
        if (source != null) {
            PersistentEntity<?, ?> sourceEntity;
            Object id;
            Class<?> sourceClass = source.getClass();
            if (ClassUtils.isCglibProxy(source)) {
                sourceClass = sourceClass.getSuperclass();
            }
            if ((id = (sourceEntity = this.getPersistentEntity(sourceClass)).getIdentifierAccessor(source).getIdentifier()) != null) {
                RepositoryInvoker repositoryInvoker = this.invokerFactory.getInvokerFor(sourceClass);
                source = repositoryInvoker.invokeFindOne((Serializable)id);
                if (source == null) {
                    throw new IllegalArgumentException(this.getText("id.notFound", new Object[0]));
                }
            } else {
                source = null;
            }
        }
        action.accept(source);
    }
}

