/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.controller;

import cn.bestwu.api.sign.ApiSign;
import cn.bestwu.framework.rest.controller.BaseController;
import cn.bestwu.framework.rest.exception.ResourceNotFoundException;
import cn.bestwu.framework.util.CaptchaUtil;
import cn.bestwu.framework.util.PinyinUtil;
import cn.bestwu.framework.util.Sha1DigestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnWebApplication
public class RootController
extends BaseController {
    @Value(value="${logging.path:}")
    private String logging_path;
    public static final String CAPTCHA = "CAPTCHA";

    @ApiSign
    @RequestMapping(value={"/utils/pinyin"}, method={RequestMethod.GET})
    public Object pinyin(String[] word) {
        Assert.notEmpty((Object[])word, (String)this.getText("param.notnull", "word"));
        HashMap map = new HashMap();
        Arrays.stream(word).forEach(w -> map.put(w, PinyinUtil.getPinYinHead(w)));
        return this.ok(map);
    }

    @RequestMapping(value={"/logs/{index}"}, method={RequestMethod.GET}, produces={"text/html", "text/plain"})
    public Object showlog(@PathVariable int index) throws IOException, ServletException {
        String logFilePath;
        File logFile;
        if (!StringUtils.hasText((String)this.logging_path)) {
            this.logging_path = this.getRealPath("/WEB-INF/logs");
        }
        if ((logFile = new File(logFilePath = index <= 0 ? this.logging_path + "/log" : (index > 1000 ? this.logging_path + "/log.1000" : this.logging_path + "/log." + index))).exists()) {
            String log = StreamUtils.copyToString((InputStream)new FileInputStream(logFile), (Charset)Charset.forName("UTF-8"));
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setETag("\"".concat(Sha1DigestUtil.shaHex(log)).concat("\""));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(RootController.cacheControl(httpHeaders))).body((Object)log);
        }
        throw new ResourceNotFoundException(this.getText("log.notFound", new Object[0]));
    }

    @RequestMapping(value={"/utils/captcha"}, method={RequestMethod.GET})
    public void captcha(HttpSession httpSession, HttpServletResponse response) throws IOException {
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        String captcha = CaptchaUtil.generateCaptcha(4);
        httpSession.setAttribute(CAPTCHA, (Object)captcha);
        ServletOutputStream outputStream = response.getOutputStream();
        CaptchaUtil.generateImage(100, 40, (OutputStream)outputStream, captcha);
        outputStream.flush();
        outputStream.close();
    }
}

