/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.resolver;

import cn.bestwu.framework.event.AddPredicateEvent;
import cn.bestwu.framework.event.DefaultPredicateEvent;
import cn.bestwu.framework.rest.resolver.RepositoryResourceMetadataHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.resolver.RootResourceInformationHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.support.Resource;
import com.querydsl.core.types.Predicate;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslRepositoryInvokerAdapter;
import org.springframework.data.querydsl.binding.FixQuerydslPredicateBuilder;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.NativeWebRequest;

public class QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver
extends RootResourceInformationHandlerMethodArgumentResolver {
    private final Repositories repositories;
    private final FixQuerydslPredicateBuilder predicateBuilder;
    private final QuerydslBindingsFactory factory;
    private final ApplicationEventPublisher publisher;

    public QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver(Repositories repositories, RepositoryInvokerFactory invokerFactory, RepositoryResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver, FixQuerydslPredicateBuilder predicateBuilder, QuerydslBindingsFactory factory, ApplicationEventPublisher publisher) {
        super(invokerFactory, resourceMetadataResolver);
        this.repositories = repositories;
        this.predicateBuilder = predicateBuilder;
        this.factory = factory;
        this.publisher = publisher;
    }

    @Override
    protected RepositoryInvoker postProcess(RepositoryInvoker invoker, Class<?> modelType, NativeWebRequest webRequest) {
        HttpServletRequest nativeRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        if (!"GET".equals(nativeRequest.getMethod()) || !nativeRequest.getServletPath().matches("^/[^/]+/?$")) {
            return invoker;
        }
        Object repository = this.repositories.getRepositoryFor(modelType);
        if (!QueryDslPredicateExecutor.class.isInstance(repository)) {
            return invoker;
        }
        ClassTypeInformation type = ClassTypeInformation.from(modelType);
        QuerydslBindings bindings = this.factory.createBindingsFor(null, (TypeInformation)type);
        MultiValueMap<String, String> parameters = QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver.toMultiValueMap(webRequest.getParameterMap());
        this.publisher.publishEvent((ApplicationEvent)new DefaultPredicateEvent(parameters, modelType));
        Predicate predicate = this.predicateBuilder.getPredicate((TypeInformation<?>)type, parameters, bindings);
        Resource<Predicate> predicateResource = new Resource<Predicate>(predicate);
        this.publisher.publishEvent((ApplicationEvent)new AddPredicateEvent(predicateResource, modelType));
        predicate = predicateResource.getContent();
        return new QuerydslRepositoryInvokerAdapter(invoker, (QueryDslPredicateExecutor)repository, predicate);
    }

    private static MultiValueMap<String, String> toMultiValueMap(Map<String, String[]> source) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        for (String key : source.keySet()) {
            result.put((Object)key, Arrays.asList((Object[])source.get(key)));
        }
        return result;
    }
}

