/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.rest.resolver;

import cn.bestwu.framework.rest.resolver.RepositoryResourceMetadataHandlerMethodArgumentResolver;
import cn.bestwu.framework.rest.support.RepositoryResourceMetadata;
import cn.bestwu.framework.rest.support.RootResourceInformation;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RootResourceInformationHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final RepositoryInvokerFactory invokerFactory;
    private final RepositoryResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver;

    public RootResourceInformationHandlerMethodArgumentResolver(RepositoryInvokerFactory invokerFactory, RepositoryResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver) {
        Assert.notNull((Object)invokerFactory, (String)"invokerFactory must not be null!");
        Assert.notNull((Object)resourceMetadataResolver, (String)"ResourceMetadataHandlerMethodArgumentResolver must not be null!");
        this.invokerFactory = invokerFactory;
        this.resourceMetadataResolver = resourceMetadataResolver;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return RootResourceInformation.class.isAssignableFrom(parameter.getParameterType());
    }

    public RootResourceInformation resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        RepositoryResourceMetadata resourceMetadata = this.resourceMetadataResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        Class<?> modelType = resourceMetadata.getModelType();
        RepositoryInvoker repositoryInvoker = this.invokerFactory.getInvokerFor(modelType);
        return new RootResourceInformation(resourceMetadata, this.postProcess(repositoryInvoker, modelType, webRequest));
    }

    protected RepositoryInvoker postProcess(RepositoryInvoker invoker, Class<?> modelType, NativeWebRequest webRequest) {
        return invoker;
    }
}

