/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.util;

import cn.bestwu.framework.util.ImageUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.springframework.util.StringUtils;

public class ImageBuilder {
    private BufferedImage bufferedImage;
    private String formatName;
    private int width;
    private int height;
    private int type;

    public ImageBuilder(Object inputStream) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        ImageReader reader = readers.next();
        reader.setInput(iis);
        this.formatName = reader.getFormatName();
        this.bufferedImage = reader.read(0);
        this.width = this.bufferedImage.getWidth();
        this.height = this.bufferedImage.getHeight();
        this.type = this.bufferedImage.getType();
        if (this.type == 0) {
            this.type = 2;
        }
        reader.dispose();
        iis.close();
    }

    public ImageBuilder scaleTrim(Integer width, Integer height) {
        double scale = 1.0;
        if (width == null) {
            width = this.width;
        }
        if (height == null) {
            height = this.height;
        }
        scale = (double)width.intValue() * scale / (double)this.width;
        double newheight = (double)this.height * scale;
        if ((double)height.intValue() > newheight) {
            scale = (double)height.intValue() * scale / newheight;
        }
        if (scale != 1.0) {
            this.scale(scale);
        }
        this.sourceRegion(width, height);
        return this;
    }

    public ImageBuilder autoScale(int min_width, int min_hight) {
        if (this.width <= min_width || this.height <= min_hight) {
            return this.scale(1.0);
        }
        double w = (double)min_width * 1.0 / (double)this.width;
        double h = (double)min_hight * 1.0 / (double)this.height;
        if (min_hight == -1) {
            return this.scale(w);
        }
        if (min_width == -1) {
            return this.scale(h);
        }
        return this.scale(w > h ? w : h);
    }

    public ImageBuilder scale(double scale) {
        if (scale != 1.0) {
            this.width = (int)Math.ceil((double)this.width * scale);
            this.height = (int)Math.ceil((double)this.height * scale);
            Image image = this.bufferedImage.getScaledInstance(this.width, this.height, 4);
            BufferedImage bufImg = new BufferedImage(image.getWidth(null), image.getHeight(null), this.type);
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            bufImg.flush();
            this.bufferedImage = bufImg;
        }
        return this;
    }

    public ImageBuilder sourceRegion(int width, int height) {
        return this.sourceRegion(width, height, Origin.CENTER);
    }

    public ImageBuilder sourceRegion(int width, int height, Origin origin) {
        if (width > this.width) {
            width = this.width;
        }
        if (height > this.height) {
            height = this.height;
        }
        int x = 0;
        int y = 0;
        switch (origin) {
            case LEFT_BOTTOM: {
                y = this.height - height;
                break;
            }
            case LEFT_TOP: {
                break;
            }
            case RIGHT_BOTTOM: {
                x = this.width - width;
                y = this.height - height;
                break;
            }
            case RIGHT_TOP: {
                x = this.width - width;
                break;
            }
            case CENTER: {
                x = (this.width - width) / 2;
                y = (this.height - height) / 2;
            }
        }
        return this.sourceRegion(x, y, width, height);
    }

    public ImageBuilder sourceRegion(int x, int y, int width, int height) {
        if (width < this.width) {
            this.width = width;
        }
        if (height < this.height) {
            this.height = height;
        }
        this.bufferedImage = this.bufferedImage.getSubimage(x, y, this.width, this.height);
        return this;
    }

    public boolean toFile(String fileName) throws IOException {
        return ImageUtil.writeImage((RenderedImage)this.bufferedImage, this.formatName, new File(fileName));
    }

    public boolean toFile(File file) throws IOException {
        return ImageUtil.writeImage((RenderedImage)this.bufferedImage, this.formatName, file);
    }

    public boolean toOutputStream(OutputStream os) throws IOException {
        return ImageUtil.writeImage((RenderedImage)this.bufferedImage, this.formatName, os);
    }

    public ImageBuilder outputFormat(String formatName) {
        if (StringUtils.hasText((String)formatName) && !this.formatName.equalsIgnoreCase(formatName)) {
            if (formatName.equalsIgnoreCase("jpg") || formatName.equalsIgnoreCase("jpeg") || formatName.equalsIgnoreCase("bmp")) {
                this.bufferedImage = this.copy(this.bufferedImage, 1);
            }
            this.formatName = formatName;
        }
        return this;
    }

    private BufferedImage copy(BufferedImage bufferedImage, int imageType) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, imageType);
        Graphics2D g = newImage.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.drawImage((Image)bufferedImage, 0, 0, null);
        g.dispose();
        return newImage;
    }

    public BufferedImage asBufferedImages() {
        return this.bufferedImage;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public int getType() {
        return this.type;
    }

    public static enum Origin {
        LEFT_BOTTOM,
        LEFT_TOP,
        RIGHT_BOTTOM,
        RIGHT_TOP,
        CENTER;

    }
}

