/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import org.springframework.util.StringUtils;

public class PinyinUtil {
    public static String getPinYin(String str, Case caze) {
        if (!StringUtils.hasText((String)str)) {
            return "";
        }
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_V);
        StringBuilder pinyin = new StringBuilder();
        try {
            char[] chars;
            for (char c : chars = str.trim().toCharArray()) {
                String[] array = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)format);
                if (array != null) {
                    String string = array[0];
                    if (caze == null) {
                        caze = Case.CAPITALIZE;
                    }
                    switch (caze) {
                        case UPPERCASE: {
                            string = string.toUpperCase();
                            break;
                        }
                        case LOWERCASE: {
                            string = string.toLowerCase();
                            break;
                        }
                        default: {
                            string = StringUtils.capitalize((String)string);
                        }
                    }
                    pinyin.append(string);
                    continue;
                }
                pinyin.append(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pinyin.toString();
    }

    public boolean isCNChar(char c) {
        return Character.toString(c).matches("[\\u4E00-\\u9FA5]+");
    }

    public boolean isBigCapital(String capital) {
        return capital.matches("[\\u0041-\\u005A]+");
    }

    public boolean isCNStr(String str) {
        for (char c : str.toCharArray()) {
            if (!this.isCNChar(c)) continue;
            return true;
        }
        return false;
    }

    public static String getPinYinHead(String str) {
        StringBuilder head = new StringBuilder();
        for (char c : str.toCharArray()) {
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)c);
            if (pinyinArray != null) {
                head.append(pinyinArray[0].charAt(0));
                continue;
            }
            head.append(c);
        }
        return head.toString().toUpperCase();
    }

    public String getHeadChar(String str) {
        return PinyinUtil.getPinYinHead(str).substring(0, 1);
    }

    public String getCnASCII(String str) {
        byte[] strByte;
        StringBuilder sb = new StringBuilder();
        for (byte aStrByte : strByte = str.getBytes()) {
            sb.append(Integer.toHexString(aStrByte & 0xFF));
        }
        return sb.toString();
    }

    public int compare(String str1, String str2) {
        return PinyinUtil.getPinYin(str1, null).compareToIgnoreCase(PinyinUtil.getPinYin(str2, null));
    }

    public static enum Case {
        UPPERCASE,
        LOWERCASE,
        CAPITALIZE;

    }
}

