/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.framework.util;

import cn.bestwu.framework.rest.converter.DefaultElementMixIn;
import cn.bestwu.framework.rest.converter.PageMixIn;
import cn.bestwu.framework.rest.converter.ResponseEntityMixIn;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.util.ClassUtils;

public class StringUtil {
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static String addUnderscores(String s) {
        StringBuilder buf = new StringBuilder(s.replace('.', '_'));
        for (int i = 1; i < buf.length() - 1; ++i) {
            if (!Character.isLowerCase(buf.charAt(i - 1)) || !Character.isUpperCase(buf.charAt(i)) || !Character.isLowerCase(buf.charAt(i + 1))) continue;
            buf.insert(i++, '_');
        }
        return buf.toString().toLowerCase(Locale.ROOT);
    }

    public static String valueOf(Object object) {
        return StringUtil.valueOf(object, false);
    }

    public static String valueOf(Object object, boolean format) {
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            int length = Array.getLength(object);
            int iMax = length - 1;
            if (iMax == -1) {
                return "[]";
            }
            StringBuilder b = new StringBuilder();
            b.append('[');
            int i = 0;
            while (true) {
                b.append(StringUtil.valueOf(Array.get(object, i), format));
                if (i == iMax) {
                    return b.append(']').toString();
                }
                b.append(", ");
                ++i;
            }
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            Enumeration es = (Enumeration)object;
            if (!es.hasMoreElements()) {
                return "[]";
            }
            StringBuilder b = new StringBuilder();
            b.append('[');
            while (es.hasMoreElements()) {
                Object e = es.nextElement();
                b.append(StringUtil.valueOf(e, format));
                if (!es.hasMoreElements()) {
                    return b.append(']').toString();
                }
                b.append(", ");
            }
        } else {
            try {
                if (format) {
                    objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
                }
                String string = null;
                if (object instanceof MappingJacksonValue) {
                    MappingJacksonValue container = (MappingJacksonValue)object;
                    Class serializationView = container.getSerializationView();
                    object = container.getValue();
                    if (serializationView != null) {
                        string = objectMapper.writerWithView(serializationView).writeValueAsString(object);
                    }
                }
                if (string == null) {
                    string = objectMapper.writeValueAsString(object);
                }
                if (format) {
                    objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
                }
                return string;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return String.valueOf(object);
    }

    public static String subString(String str, int length) {
        if (str == null) {
            return null;
        }
        int l = str.length();
        if (l > length) {
            return str.substring(0, length);
        }
        return str;
    }

    public static String subStringWithEllipsis(String str, int length) {
        if (str == null) {
            return null;
        }
        int l = str.length();
        if (l > length) {
            return str.substring(0, length - 3) + "...";
        }
        return str;
    }

    public static int countSubString(String str, String sub) {
        if (str.contains(sub)) {
            return StringUtil.splitWorker(str, sub, -1, false).length - 1;
        }
        return 0;
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        objectMapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES, new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS});
        if (ClassUtils.isPresent((String)"org.springframework.data.domain.Page", (ClassLoader)StringUtil.class.getClassLoader())) {
            objectMapper.addMixIn(Page.class, PageMixIn.class);
        }
        objectMapper.addMixIn(Object.class, DefaultElementMixIn.class);
        objectMapper.addMixIn(ResponseEntity.class, ResponseEntityMixIn.class);
        objectMapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
    }
}

